/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.IChangeCallback;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.lang.IHasSize;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.AbstractReadOnlyMapBasedMultilingualText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.IMutableMultilingualText;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractMapBasedMultilingualText
extends AbstractReadOnlyMapBasedMultilingualText
implements IMutableMultilingualText {
    private final CallbackList<IChangeCallback<IMutableMultilingualText>> m_aChangeNotifyCallbacks = new CallbackList();

    public AbstractMapBasedMultilingualText() {
    }

    protected AbstractMapBasedMultilingualText(@Nonnull ICommonsOrderedMap<Locale, String> iCommonsOrderedMap) {
        super(iCommonsOrderedMap);
    }

    @Nonnull
    private EContinue _beforeChange() {
        return this.m_aChangeNotifyCallbacks.forEachBreakable((Function<IChangeCallback<IMutableMultilingualText>, EContinue>)((Function<IChangeCallback, EContinue>)iChangeCallback -> iChangeCallback.beforeChange(this)));
    }

    private void _afterChange() {
        this.m_aChangeNotifyCallbacks.forEach((Consumer<IChangeCallback<IMutableMultilingualText>>)((Consumer<IChangeCallback>)iChangeCallback -> iChangeCallback.afterChange(this)));
    }

    @Override
    @Nonnull
    public final EChange addText(@Nonnull Locale locale, @Nullable String string) {
        ValueEnforcer.notNull(locale, "ContentLocale");
        if (this.containsLocale(locale)) {
            return EChange.UNCHANGED;
        }
        if (this._beforeChange().isBreak()) {
            return EChange.UNCHANGED;
        }
        this.internalAddText(locale, string);
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final EChange setText(@Nonnull Locale locale, @Nullable String string) {
        ValueEnforcer.notNull(locale, "ContentLocale");
        if (this.containsLocale(locale)) {
            String string2 = this.internalGetText(locale);
            if (EqualsHelper.equals(string2, string)) {
                return EChange.UNCHANGED;
            }
            if (this._beforeChange().isBreak()) {
                return EChange.UNCHANGED;
            }
            this.internalSetText(locale, string);
            this._afterChange();
            return EChange.CHANGED;
        }
        if (this._beforeChange().isBreak()) {
            return EChange.UNCHANGED;
        }
        this.internalAddText(locale, string);
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final EChange removeText(@Nonnull Locale locale) {
        ValueEnforcer.notNull(locale, "ContentLocale");
        for (Locale locale2 : LocaleHelper.getCalculatedLocaleListForResolving(locale)) {
            if (!super.containsLocale(locale2)) continue;
            if (this._beforeChange().isBreak()) {
                return EChange.UNCHANGED;
            }
            this.internalRemoveText(locale2);
            this._afterChange();
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    @Override
    @Nonnull
    public final EChange removeAll() {
        if (this.isEmpty() || this._beforeChange().isBreak()) {
            return EChange.UNCHANGED;
        }
        this.internalClear();
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final EChange assignFrom(@Nonnull IMultilingualText iMultilingualText) {
        ValueEnforcer.notNull(iMultilingualText, "MLT");
        if (this.getAllTexts().equals(iMultilingualText.getAllTexts()) || this._beforeChange().isBreak()) {
            return EChange.UNCHANGED;
        }
        this.internalClear();
        for (Map.Entry<Locale, String> entry : iMultilingualText.getAllTexts().entrySet()) {
            this.internalAddText(entry);
        }
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject(value="design")
    public final CallbackList<IChangeCallback<IMutableMultilingualText>> changeNotifyCallbacks() {
        return this.m_aChangeNotifyCallbacks;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).appendIf("ChangeNotifyCallbacks", this.m_aChangeNotifyCallbacks, IHasSize::isNotEmpty).getToString();
    }
}

