/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.ws;

import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.string.ToStringGenerator;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostnameVerifierVerifyAll
implements HostnameVerifier {
    private static final Logger s_aLogger = LoggerFactory.getLogger(HostnameVerifierVerifyAll.class);
    private final boolean m_bDebug;

    public HostnameVerifierVerifyAll() {
        this(GlobalDebug.isDebugMode());
    }

    public HostnameVerifierVerifyAll(boolean bl) {
        this.m_bDebug = bl;
    }

    public boolean isDebug() {
        return this.m_bDebug;
    }

    @Override
    public boolean verify(String string, SSLSession sSLSession) {
        if (this.m_bDebug) {
            s_aLogger.info("Hostname '" + string + "' is accepted by default in SSL session " + sSLSession + "!");
        }
        return true;
    }

    public String toString() {
        return new ToStringGenerator(this).append("debug", this.m_bDebug).getToString();
    }
}

