/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HasInputStream
implements IHasInputStream {
    private final ISupplier<? extends InputStream> m_aISP;
    private final boolean m_bReadMultiple;

    public HasInputStream(@Nonnull ISupplier<? extends InputStream> iSupplier, boolean bl) {
        this.m_aISP = ValueEnforcer.notNull(iSupplier, "ISP");
        this.m_bReadMultiple = bl;
    }

    @Override
    public final boolean isReadMultiple() {
        return this.m_bReadMultiple;
    }

    @Override
    public final InputStream getInputStream() {
        return (InputStream)this.m_aISP.get();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ISP", this.m_aISP).append("ReadMultiple", this.m_bReadMultiple).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HasInputStream multiple(@Nonnull ISupplier<? extends InputStream> iSupplier) {
        return new HasInputStream(iSupplier, true);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HasInputStream once(@Nonnull ISupplier<? extends InputStream> iSupplier) {
        return new HasInputStream(iSupplier, false);
    }
}

