/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.random;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.lang.TimeValue;
import com.helger.commons.timing.StopWatch;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class VerySecureRandom {
    public static final int DEFAULT_RE_SEED_INTERVAL = 20;
    private static final Logger LOGGER;
    private static final int SEED_BYTE_COUNT = 64;
    private static final SecureRandom s_aSecureRandom;
    private static final VerySecureRandom s_aInstance;
    private static final AtomicInteger s_aReSeedInterval;
    private static final AtomicInteger s_aCounter;

    @Nonnull
    private static SecureRandom _createSecureRandomInstance() {
        SecureRandom secureRandom;
        block9: {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Trying to get SecureRandom: IBMSecureRandom, IBMJCE");
                }
                secureRandom = SecureRandom.getInstance("IBMSecureRandom", "IBMJCE");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using SecureRandom: IBMSecureRandom, IBMJCE");
                }
            }
            catch (Exception exception) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Trying to get SecureRandom: SHA1PRNG");
                    }
                    secureRandom = SecureRandom.getInstance("SHA1PRNG");
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Using SecureRandom: SHA1PRNG");
                    }
                }
                catch (Exception exception2) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Trying to get default SecureRandom");
                    }
                    secureRandom = new SecureRandom();
                    if (!LOGGER.isDebugEnabled()) break block9;
                    LOGGER.debug("Using default SecureRandom");
                }
            }
        }
        return secureRandom;
    }

    private VerySecureRandom() {
    }

    public static void setReSeedInterval(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ReseedInterval");
        s_aReSeedInterval.set(n);
    }

    @Nonnegative
    public static int getReSeedInterval() {
        return s_aReSeedInterval.get();
    }

    @Nonnull
    public static SecureRandom getInstance() {
        int n = VerySecureRandom.getReSeedInterval();
        if (n > 0 && s_aCounter.incrementAndGet() % n == 0) {
            TimeValue timeValue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Re-seeding VerySecureRandom");
            }
            if ((timeValue = StopWatch.runMeasured(() -> s_aSecureRandom.setSeed(s_aSecureRandom.generateSeed(64)))).getAsMillis() > 500L) {
                LOGGER.warn("Re-seeding VerySecureRandom took too long (" + timeValue.getAsMillis() + " milliseconds) - you may consider using '/dev/urandom'");
            }
        }
        return s_aSecureRandom;
    }

    static {
        SecureRandom secureRandom;
        block8: {
            LOGGER = LoggerFactory.getLogger(VerySecureRandom.class);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Strong SecureRandoms: " + Security.getProperty("securerandom.strongAlgorithms"));
            }
            try {
                secureRandom = SecureRandom.getInstanceStrong();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("SecureRandom.getInstanceStrong () was successful");
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                try {
                    secureRandom = SecureRandom.getInstance("NativePRNGNonBlocking");
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("SecureRandom.getInstance ('NativePRNGNonBLocking') was successful");
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    secureRandom = new SecureRandom();
                    if (!LOGGER.isDebugEnabled()) break block8;
                    LOGGER.debug("Falling back to default SecureRandom for initialization");
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Generating intial seed for VerySecureRandom");
        }
        byte[] byArray = secureRandom.generateSeed(64);
        s_aSecureRandom = VerySecureRandom._createSecureRandomInstance();
        s_aSecureRandom.setSeed(byArray);
        s_aInstance = new VerySecureRandom();
        s_aReSeedInterval = new AtomicInteger(20);
        s_aCounter = new AtomicInteger(0);
    }
}

