/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.parser;

import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.holiday.CalendarHelper;
import com.helger.holiday.HolidayMap;
import com.helger.holiday.IHolidayType;
import com.helger.holiday.ResourceBundleHoliday;
import com.helger.holiday.jaxb.EthiopianOrthodoxHoliday;
import com.helger.holiday.jaxb.Holidays;
import com.helger.holiday.mgr.XMLHolidayHelper;
import com.helger.holiday.parser.AbstractHolidayParser;
import java.time.LocalDate;
import java.time.chrono.Chronology;
import org.threeten.extra.chrono.CopticChronology;

public final class EthiopianOrthodoxHolidayParser
extends AbstractHolidayParser {
    private static final EthiopianOrthodoxHolidayParser s_aInstance = new EthiopianOrthodoxHolidayParser();

    private EthiopianOrthodoxHolidayParser() {
    }

    public static EthiopianOrthodoxHolidayParser getInstance() {
        return s_aInstance;
    }

    private static ICommonsSet<LocalDate> _getEthiopianOrthodoxHolidaysInGregorianYear(int n, int n2, int n3) {
        return CalendarHelper.getDatesFromChronologyWithinGregorianYear(n2, n3, n, (Chronology)CopticChronology.INSTANCE);
    }

    @Override
    public void parse(int n, HolidayMap holidayMap, Holidays holidays) {
        for (EthiopianOrthodoxHoliday ethiopianOrthodoxHoliday : holidays.getEthiopianOrthodoxHoliday()) {
            ICommonsSet<LocalDate> iCommonsSet;
            if (!EthiopianOrthodoxHolidayParser.isValid(ethiopianOrthodoxHoliday, n)) continue;
            switch (ethiopianOrthodoxHoliday.getType()) {
                case TIMKAT: {
                    iCommonsSet = EthiopianOrthodoxHolidayParser._getEthiopianOrthodoxHolidaysInGregorianYear(n, 5, 10);
                    break;
                }
                case ENKUTATASH: {
                    iCommonsSet = EthiopianOrthodoxHolidayParser._getEthiopianOrthodoxHolidaysInGregorianYear(n, 1, 1);
                    break;
                }
                case MESKEL: {
                    iCommonsSet = EthiopianOrthodoxHolidayParser._getEthiopianOrthodoxHolidaysInGregorianYear(n, 1, 17);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ethiopian orthodox holiday type " + (Object)((Object)ethiopianOrthodoxHoliday.getType()));
                }
            }
            IHolidayType iHolidayType = XMLHolidayHelper.getType(ethiopianOrthodoxHoliday.getLocalizedType());
            String string = "ethiopian.orthodox." + ethiopianOrthodoxHoliday.getType().name();
            for (LocalDate localDate : iCommonsSet) {
                holidayMap.add(localDate, new ResourceBundleHoliday(iHolidayType, string));
            }
        }
    }
}

