/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.parser;

import com.helger.holiday.HolidayMap;
import com.helger.holiday.IHolidayType;
import com.helger.holiday.ResourceBundleHoliday;
import com.helger.holiday.jaxb.FixedWeekdayInMonth;
import com.helger.holiday.jaxb.Holidays;
import com.helger.holiday.jaxb.Which;
import com.helger.holiday.mgr.XMLHolidayHelper;
import com.helger.holiday.parser.AbstractHolidayParser;
import java.time.DayOfWeek;
import java.time.LocalDate;

public class FixedWeekdayInMonthParser
extends AbstractHolidayParser {
    private static final FixedWeekdayInMonthParser s_aInstance = new FixedWeekdayInMonthParser();

    protected FixedWeekdayInMonthParser() {
    }

    public static FixedWeekdayInMonthParser getInstance() {
        return s_aInstance;
    }

    @Override
    public void parse(int n, HolidayMap holidayMap, Holidays holidays) {
        for (FixedWeekdayInMonth fixedWeekdayInMonth : holidays.getFixedWeekday()) {
            if (!FixedWeekdayInMonthParser.isValid(fixedWeekdayInMonth, n)) continue;
            LocalDate localDate = FixedWeekdayInMonthParser.parse(n, fixedWeekdayInMonth);
            IHolidayType iHolidayType = XMLHolidayHelper.getType(fixedWeekdayInMonth.getLocalizedType());
            String string = fixedWeekdayInMonth.getDescriptionPropertiesKey();
            holidayMap.add(localDate, new ResourceBundleHoliday(iHolidayType, string));
        }
    }

    protected static LocalDate parse(int n, FixedWeekdayInMonth fixedWeekdayInMonth) {
        LocalDate localDate = LocalDate.of(n, XMLHolidayHelper.getMonth(fixedWeekdayInMonth.getMonth()), 1);
        int n2 = 1;
        if (fixedWeekdayInMonth.getWhich() == Which.LAST) {
            localDate = localDate.plusMonths(1L).withDayOfMonth(1).minusDays(1L);
            n2 = -1;
        }
        DayOfWeek dayOfWeek = XMLHolidayHelper.getWeekday(fixedWeekdayInMonth.getWeekday());
        while (localDate.getDayOfWeek() != dayOfWeek) {
            localDate = localDate.plusDays(n2);
        }
        switch (fixedWeekdayInMonth.getWhich()) {
            case FIRST: {
                break;
            }
            case SECOND: {
                localDate = localDate.plusDays(7L);
                break;
            }
            case THIRD: {
                localDate = localDate.plusDays(14L);
                break;
            }
            case FOURTH: {
                localDate = localDate.plusDays(21L);
                break;
            }
        }
        return localDate;
    }
}

