/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.parser;

import com.helger.holiday.HolidayMap;
import com.helger.holiday.IHolidayType;
import com.helger.holiday.ResourceBundleHoliday;
import com.helger.holiday.jaxb.Fixed;
import com.helger.holiday.jaxb.Holidays;
import com.helger.holiday.mgr.XMLHolidayHelper;
import com.helger.holiday.parser.AbstractHolidayParser;
import java.time.LocalDate;

public final class FixedParser
extends AbstractHolidayParser {
    private static final FixedParser s_aInstance = new FixedParser();

    private FixedParser() {
    }

    public static FixedParser getInstance() {
        return s_aInstance;
    }

    @Override
    public void parse(int n, HolidayMap holidayMap, Holidays holidays) {
        for (Fixed fixed : holidays.getFixed()) {
            if (!FixedParser.isValid(fixed, n)) continue;
            LocalDate localDate = XMLHolidayHelper.create(n, fixed);
            LocalDate localDate2 = FixedParser.moveDate(fixed, localDate);
            IHolidayType iHolidayType = XMLHolidayHelper.getType(fixed.getLocalizedType());
            String string = fixed.getDescriptionPropertiesKey();
            holidayMap.add(localDate2, new ResourceBundleHoliday(iHolidayType, string));
        }
    }
}

