/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.parser;

import com.helger.holiday.HolidayMap;
import com.helger.holiday.IHolidayType;
import com.helger.holiday.ResourceBundleHoliday;
import com.helger.holiday.jaxb.Holidays;
import com.helger.holiday.jaxb.RelativeToWeekdayInMonth;
import com.helger.holiday.jaxb.When;
import com.helger.holiday.mgr.XMLHolidayHelper;
import com.helger.holiday.parser.FixedWeekdayInMonthParser;
import java.time.DayOfWeek;
import java.time.LocalDate;

public final class RelativeToWeekdayInMonthParser
extends FixedWeekdayInMonthParser {
    private static final RelativeToWeekdayInMonthParser s_aInstance = new RelativeToWeekdayInMonthParser();

    private RelativeToWeekdayInMonthParser() {
    }

    public static RelativeToWeekdayInMonthParser getInstance() {
        return s_aInstance;
    }

    @Override
    public void parse(int n, HolidayMap holidayMap, Holidays holidays) {
        for (RelativeToWeekdayInMonth relativeToWeekdayInMonth : holidays.getRelativeToWeekdayInMonth()) {
            int n2;
            if (!RelativeToWeekdayInMonthParser.isValid(relativeToWeekdayInMonth, n)) continue;
            DayOfWeek dayOfWeek = XMLHolidayHelper.getWeekday(relativeToWeekdayInMonth.getWeekday());
            LocalDate localDate = RelativeToWeekdayInMonthParser.parse(n, relativeToWeekdayInMonth.getFixedWeekday());
            int n3 = n2 = relativeToWeekdayInMonth.getWhen() == When.BEFORE ? -1 : 1;
            while (localDate.getDayOfWeek() != dayOfWeek) {
                localDate = localDate.plusDays(n2);
            }
            IHolidayType iHolidayType = XMLHolidayHelper.getType(relativeToWeekdayInMonth.getLocalizedType());
            String string = relativeToWeekdayInMonth.getDescriptionPropertiesKey();
            holidayMap.add(localDate, new ResourceBundleHoliday(iHolidayType, string));
        }
    }
}

