/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.lang.IHasClassLoader;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class JAXBContextCacheKey
implements IHasClassLoader {
    private final Package m_aPackage;
    private final ClassLoader m_aClassLoader;

    public JAXBContextCacheKey(@Nonnull Package package_, @Nullable ClassLoader classLoader) {
        this.m_aPackage = (Package)ValueEnforcer.notNull((Object)package_, (String)"Package");
        this.m_aClassLoader = classLoader != null ? classLoader : ClassLoaderHelper.getDefaultClassLoader();
    }

    @Nonnull
    public Package getPackage() {
        return this.m_aPackage;
    }

    @Nonnull
    public ClassLoader getClassLoader() {
        return this.m_aClassLoader;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JAXBContextCacheKey jAXBContextCacheKey = (JAXBContextCacheKey)object;
        return this.m_aPackage.equals(jAXBContextCacheKey.m_aPackage) && this.m_aClassLoader.equals(jAXBContextCacheKey.m_aClassLoader);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aPackage).append((Object)this.m_aClassLoader).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Package", (Object)this.m_aPackage).append("ClassLoader", (Object)this.m_aClassLoader).getToString();
    }
}

