/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.lang.IHasClassLoader;
import com.helger.commons.string.ToStringGenerator;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class JAXBContextCacheKey
implements IHasClassLoader {
    private final Package m_aPackage;
    private final WeakReference<ClassLoader> m_aClassLoader;

    public JAXBContextCacheKey(@Nonnull Package package_, @Nullable ClassLoader classLoader) {
        this.m_aPackage = (Package)ValueEnforcer.notNull((Object)package_, (String)"Package");
        this.m_aClassLoader = new WeakReference<ClassLoader>(classLoader);
    }

    @Nonnull
    public Package getPackage() {
        return this.m_aPackage;
    }

    @Nonnull
    public final ClassLoader getClassLoader() {
        ClassLoader classLoader = (ClassLoader)this.m_aClassLoader.get();
        return classLoader != null ? classLoader : ClassLoaderHelper.getDefaultClassLoader();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JAXBContextCacheKey jAXBContextCacheKey = (JAXBContextCacheKey)object;
        return this.m_aPackage.equals(jAXBContextCacheKey.m_aPackage) && EqualsHelper.equals((Object)this.getClassLoader(), (Object)jAXBContextCacheKey.getClassLoader());
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aPackage).append((Object)this.getClassLoader()).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Package", (Object)this.m_aPackage).append("ClassLoader", this.m_aClassLoader).getToString();
    }
}

