/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.ICallback;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.IJAXBReader;
import com.helger.jaxb.builder.AbstractJAXBBuilder;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.jaxb.builder.JAXBBuilderDefaultSettings;
import com.helger.jaxb.validation.LoggingValidationEventHandler;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

@NotThreadSafe
public class JAXBReaderBuilder<JAXBTYPE, IMPLTYPE extends JAXBReaderBuilder<JAXBTYPE, IMPLTYPE>>
extends AbstractJAXBBuilder<IMPLTYPE>
implements IJAXBReader<JAXBTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBReaderBuilder.class);
    private final Class<JAXBTYPE> m_aImplClass;
    private ValidationEventHandler m_aEventHandler = JAXBBuilderDefaultSettings.getDefaultValidationEventHandler();
    private final CallbackList<IExceptionCallback<JAXBException>> m_aExceptionCallbacks = new CallbackList();
    private Consumer<? super Unmarshaller> m_aUnmarshallerCustomizer;
    private boolean m_bReadSecure = true;

    public JAXBReaderBuilder(@Nonnull IJAXBDocumentType iJAXBDocumentType) {
        this(iJAXBDocumentType, (Class)GenericReflection.uncheckedCast(iJAXBDocumentType.getImplementationClass()));
    }

    public JAXBReaderBuilder(@Nonnull IJAXBDocumentType iJAXBDocumentType, @Nonnull Class<JAXBTYPE> clazz) {
        super(iJAXBDocumentType);
        this.m_aImplClass = (Class)ValueEnforcer.notNull(clazz, (String)"ImplClass");
        this.m_aExceptionCallbacks.add((ICallback)new DefaultExceptionHandler());
    }

    @Nonnull
    protected final Class<JAXBTYPE> getImplClass() {
        return this.m_aImplClass;
    }

    @Nullable
    public ValidationEventHandler getValidationEventHandler() {
        return this.m_aEventHandler;
    }

    @Nonnull
    public final IMPLTYPE setValidationEventHandler(@Nullable ValidationEventHandler validationEventHandler) {
        this.m_aEventHandler = validationEventHandler;
        return (IMPLTYPE)((JAXBReaderBuilder)this.thisAsT());
    }

    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IExceptionCallback<JAXBException>> exceptionCallbacks() {
        return this.m_aExceptionCallbacks;
    }

    @Nullable
    public Consumer<? super Unmarshaller> getUnmarshallerCustomizer() {
        return this.m_aUnmarshallerCustomizer;
    }

    @Nonnull
    public final IMPLTYPE setUnmarshallerCustomizer(@Nullable Consumer<? super Unmarshaller> consumer) {
        this.m_aUnmarshallerCustomizer = consumer;
        return (IMPLTYPE)((JAXBReaderBuilder)this.thisAsT());
    }

    @Override
    public final boolean isReadSecure() {
        return this.m_bReadSecure;
    }

    @Nonnull
    public final IMPLTYPE setReadSecure(boolean bl) {
        this.m_bReadSecure = bl;
        return (IMPLTYPE)((JAXBReaderBuilder)this.thisAsT());
    }

    @Nonnull
    protected Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext jAXBContext = this.getJAXBContext();
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        if (this.m_aEventHandler != null) {
            unmarshaller.setEventHandler(this.m_aEventHandler);
        } else {
            unmarshaller.setEventHandler((ValidationEventHandler)new LoggingValidationEventHandler().andThen(unmarshaller.getEventHandler()));
        }
        Schema schema = this.getSchema();
        if (schema != null) {
            unmarshaller.setSchema(schema);
        }
        return unmarshaller;
    }

    @Override
    @Nullable
    public JAXBTYPE read(@Nonnull IJAXBReader.IJAXBUnmarshaller<JAXBTYPE> iJAXBUnmarshaller) {
        ValueEnforcer.notNull(iJAXBUnmarshaller, (String)"Handler");
        Schema schema = this.getSchema();
        if (schema == null && this.isUseSchema()) {
            LOGGER.warn("Don't know how to read JAXB document of type " + this.m_aImplClass.getName());
        }
        Object object = null;
        try {
            JAXBElement<JAXBTYPE> jAXBElement;
            Unmarshaller unmarshaller = this.createUnmarshaller();
            if (this.m_aUnmarshallerCustomizer != null) {
                this.m_aUnmarshallerCustomizer.accept((Unmarshaller)unmarshaller);
            }
            if ((object = (jAXBElement = iJAXBUnmarshaller.doUnmarshal(unmarshaller, this.m_aImplClass)).getValue()) == null) {
                throw new IllegalStateException("Failed to read JAXB document of class " + this.m_aImplClass.getName() + " - without exception!");
            }
        }
        catch (JAXBException jAXBException) {
            this.m_aExceptionCallbacks.forEach(iExceptionCallback -> iExceptionCallback.onException((Throwable)jAXBException));
        }
        return (JAXBTYPE)object;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("ImplClass", this.m_aImplClass).append("EventHandler", (Object)this.m_aEventHandler).append("ExceptionHandler", this.m_aExceptionCallbacks).append("UnmarshallerCustomizer", this.m_aUnmarshallerCustomizer).append("ReadSecure", this.m_bReadSecure).getToString();
    }

    public static class DefaultExceptionHandler
    implements IExceptionCallback<JAXBException> {
        private static final Logger LOGGER2 = LoggerFactory.getLogger(DefaultExceptionHandler.class);

        public void onException(@Nonnull JAXBException jAXBException) {
            if (jAXBException instanceof UnmarshalException) {
                Throwable throwable = ((UnmarshalException)jAXBException).getLinkedException();
                if (throwable instanceof SAXParseException) {
                    LOGGER2.error("Failed to parse XML document: " + throwable.getMessage());
                } else {
                    LOGGER2.error("Unmarshal exception reading document", (Throwable)jAXBException);
                }
            } else {
                LOGGER2.warn("JAXB Exception reading document", (Throwable)jAXBException);
            }
        }
    }
}

