/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.convert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.typeconvert.TypeConverterException;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverterRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MicroTypeConverter {
    private static final MicroTypeConverter s_aInstance = new MicroTypeConverter();

    private MicroTypeConverter() {
    }

    @Nullable
    public static IMicroElement convertToMicroElement(@Nullable Object object, @Nonnull @Nonempty String string) {
        return MicroTypeConverter.convertToMicroElement(object, null, string);
    }

    @Nullable
    public static IMicroElement convertToMicroElement(@Nullable Object object, @Nullable String string, @Nonnull @Nonempty String string2) throws TypeConverterException {
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"TagName");
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        IMicroTypeConverter iMicroTypeConverter = MicroTypeConverterRegistry.getInstance().getConverterToMicroElement(clazz);
        if (iMicroTypeConverter == null) {
            throw new TypeConverterException(clazz, IMicroElement.class, TypeConverterException.EReason.NO_CONVERTER_FOUND);
        }
        IMicroElement iMicroElement = iMicroTypeConverter.convertToMicroElement(object, string, string2);
        if (iMicroElement == null) {
            throw new TypeConverterException(clazz, IMicroElement.class, TypeConverterException.EReason.CONVERSION_FAILED);
        }
        return iMicroElement;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convertToNative(@Nullable IMicroElement iMicroElement, @Nonnull Class<DSTTYPE> clazz) throws TypeConverterException {
        return MicroTypeConverter.convertToNative(iMicroElement, clazz, null);
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convertToNative(@Nullable IMicroElement iMicroElement, @Nonnull Class<DSTTYPE> clazz, @Nullable DSTTYPE DSTTYPE) throws TypeConverterException {
        ValueEnforcer.notNull(clazz, (String)"DestClass");
        if (iMicroElement == null) {
            return DSTTYPE;
        }
        IMicroTypeConverter iMicroTypeConverter = MicroTypeConverterRegistry.getInstance().getConverterToNative(clazz);
        if (iMicroTypeConverter == null) {
            throw new TypeConverterException(IMicroElement.class, clazz, TypeConverterException.EReason.NO_CONVERTER_FOUND);
        }
        DSTTYPE DSTTYPE2 = clazz.cast(iMicroTypeConverter.convertToNative(iMicroElement));
        if (DSTTYPE2 == null) {
            throw new TypeConverterException(IMicroElement.class, clazz, TypeConverterException.EReason.CONVERSION_FAILED);
        }
        return DSTTYPE2;
    }
}

