/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.serialize;

import com.helger.commons.CGlobal;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.string.StringHelper;
import com.helger.xml.microdom.IMicroCDATA;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.MicroDocumentType;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;

public class MicroSAXHandler
implements EntityResolver2,
DTDHandler,
ContentHandler,
ErrorHandler,
LexicalHandler {
    private static final Logger s_aLogger = LoggerFactory.getLogger(MicroSAXHandler.class);
    private IMicroDocument m_aDoc;
    private IMicroDocumentType m_aDocType;
    private IMicroNode m_aParent;
    private boolean m_bDTDMode = false;
    private boolean m_bCDATAMode = false;
    private final boolean m_bSaveIgnorableWhitespaces;
    private final EntityResolver m_aEntityResolver;
    private final EntityResolver2 m_aEntityResolver2;

    public MicroSAXHandler(boolean bl, @Nullable EntityResolver entityResolver) {
        this.m_bSaveIgnorableWhitespaces = bl;
        this.m_aEntityResolver = entityResolver;
        this.m_aEntityResolver2 = entityResolver instanceof EntityResolver2 ? (EntityResolver2)entityResolver : null;
    }

    private void _createParentDocument() {
        if (this.m_aParent == null) {
            this.m_aDoc = new MicroDocument(this.m_aDocType);
            this.m_aParent = this.m_aDoc;
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.m_aDocType == null) {
            this.m_aDocType = new MicroDocumentType(string, string2, string3);
        } else {
            s_aLogger.warn("DocType already present!");
        }
        this.m_bDTDMode = true;
    }

    @Override
    public void endDTD() throws SAXException {
        this.m_bDTDMode = false;
    }

    @Override
    public void startElement(@Nullable String string, @Nonnull String string2, @Nullable String string3, @Nullable Attributes attributes) {
        this._createParentDocument();
        IMicroElement iMicroElement = StringHelper.hasText((String)string) ? this.m_aParent.appendElement(string, string2) : this.m_aParent.appendElement(string2);
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string4 = attributes.getURI(i);
                String string5 = attributes.getLocalName(i);
                String string6 = attributes.getValue(i);
                if (string5.startsWith("xmlns")) continue;
                iMicroElement.setAttribute(string4, string5, string6);
            }
        }
        this.m_aParent = iMicroElement;
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.m_aParent = this.m_aParent.getParent();
    }

    @Override
    public void characters(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (this.m_bCDATAMode) {
            IMicroNode iMicroNode = this.m_aParent.getLastChild();
            if (iMicroNode != null && iMicroNode.getType().isCDATA()) {
                IMicroCDATA iMicroCDATA = (IMicroCDATA)iMicroNode;
                iMicroCDATA.appendData(cArray, n, n2);
            } else {
                this.m_aParent.appendCDATA(cArray, n, n2);
            }
        } else {
            IMicroNode iMicroNode = this.m_aParent.getLastChild();
            if (iMicroNode != null && iMicroNode.getType().isText()) {
                IMicroText iMicroText = (IMicroText)iMicroNode;
                if (!iMicroText.isElementContentWhitespace()) {
                    iMicroText.appendData(cArray, n, n2);
                } else {
                    this.m_aParent.appendText(cArray, n, n2);
                }
            } else {
                this.m_aParent.appendText(cArray, n, n2);
            }
        }
    }

    @Override
    public void ignorableWhitespace(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (this.m_bSaveIgnorableWhitespaces) {
            IMicroNode iMicroNode = this.m_aParent.getLastChild();
            if (iMicroNode != null && iMicroNode.getType().isText()) {
                IMicroText iMicroText = (IMicroText)iMicroNode;
                if (iMicroText.isElementContentWhitespace()) {
                    iMicroText.appendData(cArray, n, n2);
                } else {
                    this.m_aParent.appendIgnorableWhitespaceText(cArray, n, n2);
                }
            } else {
                this.m_aParent.appendIgnorableWhitespaceText(cArray, n, n2);
            }
        }
    }

    @Override
    public void processingInstruction(String string, String string2) {
        this._createParentDocument();
        this.m_aParent.appendProcessingInstruction(string, string2);
    }

    @Override
    @Nullable
    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        EntityResolver entityResolver = this.m_aEntityResolver;
        if (entityResolver != null) {
            return entityResolver.resolveEntity(string, string2);
        }
        if (string == null) {
            s_aLogger.info("Need to resolve entity with system ID '" + string2 + "'");
        } else if (string2 == null) {
            s_aLogger.info("Need to resolve entity with public ID '" + string + "'");
        } else {
            s_aLogger.info("Need to resolve entity with public ID '" + string + "' and system ID '" + string2 + "'");
        }
        return null;
    }

    @Override
    @Nullable
    public InputSource getExternalSubset(String string, @Nullable String string2) throws SAXException, IOException {
        EntityResolver2 entityResolver2 = this.m_aEntityResolver2;
        if (entityResolver2 != null) {
            return entityResolver2.getExternalSubset(string, string2);
        }
        return null;
    }

    @Override
    @Nullable
    public InputSource resolveEntity(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nonnull String string4) throws SAXException, IOException {
        EntityResolver2 entityResolver2 = this.m_aEntityResolver2;
        if (entityResolver2 != null) {
            return entityResolver2.resolveEntity(string, string2, string3, string4);
        }
        EntityResolver entityResolver = this.m_aEntityResolver;
        if (entityResolver != null) {
            return entityResolver.resolveEntity(string2, string4);
        }
        s_aLogger.info("Need to resolve entity with name '" + string + "', public ID '" + string2 + "' base URI '" + string3 + "' and system ID '" + string4 + "'");
        return null;
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        s_aLogger.warn("Unparsed entity decl: " + string + "--" + string2 + "--" + string3 + "--" + string4);
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        s_aLogger.warn("Unparsed notation decl: " + string + "--" + string2 + "--" + string3);
    }

    @Override
    public void skippedEntity(String string) {
        s_aLogger.warn("Skipped entity: " + string);
    }

    @Override
    public void startPrefixMapping(@Nonnull String string, @Nonnull String string2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(@Nonnull String string) throws SAXException {
    }

    @Nonnull
    @Nonempty
    private static String _getMsg(@Nonnull IErrorLevel iErrorLevel, @Nonnull SAXParseException sAXParseException) {
        return AbstractSAXErrorHandler.getSaxParseError(iErrorLevel, sAXParseException).getAsString(CGlobal.DEFAULT_LOCALE);
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        s_aLogger.warn(MicroSAXHandler._getMsg((IErrorLevel)EErrorLevel.WARN, sAXParseException));
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        s_aLogger.error(MicroSAXHandler._getMsg((IErrorLevel)EErrorLevel.ERROR, sAXParseException));
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        s_aLogger.error(MicroSAXHandler._getMsg((IErrorLevel)EErrorLevel.FATAL_ERROR, sAXParseException));
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_bCDATAMode = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_bCDATAMode = false;
    }

    @Override
    public void comment(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) throws SAXException {
        if (!this.m_bDTDMode) {
            this._createParentDocument();
            this.m_aParent.appendComment(cArray, n, n2);
        }
    }

    @Nullable
    public IMicroDocument getDocument() {
        return this.m_aDoc;
    }
}

