/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.serialize;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ext.CommonsLinkedHashMap;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsOrderedMap;
import com.helger.commons.string.StringHelper;
import com.helger.xml.microdom.IMicroAttribute;
import com.helger.xml.microdom.IMicroCDATA;
import com.helger.xml.microdom.IMicroComment;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroEntityReference;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroProcessingInstruction;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.serialize.write.AbstractXMLSerializer;
import com.helger.xml.serialize.write.EXMLSerializeBracketMode;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLEmitter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;

public class MicroSerializer
extends AbstractXMLSerializer<IMicroNode> {
    public MicroSerializer() {
        this(XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    public MicroSerializer(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        super(iXMLWriterSettings);
    }

    @Override
    protected void emitNode(@Nonnull XMLEmitter xMLEmitter, @Nullable IMicroNode iMicroNode, @Nullable IMicroNode iMicroNode2, @Nonnull IMicroNode iMicroNode3, @Nullable IMicroNode iMicroNode4) {
        ValueEnforcer.notNull((Object)iMicroNode3, (String)"Node");
        switch (iMicroNode3.getType()) {
            case ELEMENT: {
                this._writeElement(xMLEmitter, iMicroNode, iMicroNode2, (IMicroElement)iMicroNode3, iMicroNode4);
                break;
            }
            case TEXT: {
                MicroSerializer._writeText(xMLEmitter, (IMicroText)iMicroNode3);
                break;
            }
            case CDATA: {
                MicroSerializer._writeCDATA(xMLEmitter, (IMicroCDATA)iMicroNode3);
                break;
            }
            case COMMENT: {
                this._writeComment(xMLEmitter, (IMicroComment)iMicroNode3);
                break;
            }
            case ENTITY_REFERENCE: {
                MicroSerializer._writeEntityReference(xMLEmitter, (IMicroEntityReference)iMicroNode3);
                break;
            }
            case DOCUMENT: {
                this._writeDocument(xMLEmitter, (IMicroDocument)iMicroNode3);
                break;
            }
            case DOCUMENT_TYPE: {
                this._writeDocumentType(xMLEmitter, (IMicroDocumentType)iMicroNode3);
                break;
            }
            case PROCESSING_INSTRUCTION: {
                MicroSerializer._writeProcessingInstruction(xMLEmitter, (IMicroProcessingInstruction)iMicroNode3);
                break;
            }
            case CONTAINER: {
                this._writeContainer(xMLEmitter, iMicroNode, (IMicroContainer)iMicroNode3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Passed node type " + iMicroNode3.getClass().getName() + " is not yet supported");
            }
        }
    }

    private void _writeNodeList(@Nonnull XMLEmitter xMLEmitter, @Nullable IMicroNode iMicroNode, @Nonnull List<IMicroNode> list) {
        int n = list.size() - 1;
        for (int i = 0; i <= n; ++i) {
            this.emitNode(xMLEmitter, iMicroNode, i == 0 ? null : list.get(i - 1), list.get(i), i == n ? null : list.get(i + 1));
        }
    }

    private void _writeDocument(@Nonnull XMLEmitter xMLEmitter, IMicroDocument iMicroDocument) {
        if (this.m_aSettings.getSerializeXMLDeclaration().isEmit()) {
            xMLEmitter.onXMLDeclaration(this.m_aSettings.getXMLVersion(), this.m_aSettings.getCharset(), iMicroDocument.isStandalone());
        }
        if (iMicroDocument.hasChildren()) {
            this._writeNodeList(xMLEmitter, iMicroDocument, (List<IMicroNode>)iMicroDocument.getAllChildren());
        }
    }

    private void _writeDocumentType(@Nonnull XMLEmitter xMLEmitter, IMicroDocumentType iMicroDocumentType) {
        if (this.m_aSettings.getSerializeDocType().isEmit()) {
            xMLEmitter.onDocumentType(iMicroDocumentType.getQualifiedName(), iMicroDocumentType.getPublicID(), iMicroDocumentType.getSystemID());
        }
    }

    private static void _writeProcessingInstruction(@Nonnull XMLEmitter xMLEmitter, @Nonnull IMicroProcessingInstruction iMicroProcessingInstruction) {
        xMLEmitter.onProcessingInstruction(iMicroProcessingInstruction.getTarget(), iMicroProcessingInstruction.getData());
    }

    private void _writeContainer(@Nonnull XMLEmitter xMLEmitter, @Nonnull IMicroNode iMicroNode, @Nonnull IMicroContainer iMicroContainer) {
        if (iMicroContainer.hasChildren()) {
            this._writeNodeList(xMLEmitter, iMicroNode, (List<IMicroNode>)iMicroContainer.getAllChildren());
        }
    }

    private static void _writeEntityReference(@Nonnull XMLEmitter xMLEmitter, @Nonnull IMicroEntityReference iMicroEntityReference) {
        xMLEmitter.onEntityReference(iMicroEntityReference.getName());
    }

    private static void _writeText(@Nonnull XMLEmitter xMLEmitter, @Nonnull IMicroText iMicroText) {
        xMLEmitter.onText(iMicroText.getData().toString(), iMicroText.isEscape());
    }

    private void _writeComment(@Nonnull XMLEmitter xMLEmitter, @Nonnull IMicroComment iMicroComment) {
        if (this.m_aSettings.getSerializeComments().isEmit()) {
            if (this.m_aSettings.getIndent().isIndent() && this.m_aIndent.length() > 0) {
                xMLEmitter.onContentElementWhitespace(this.m_aIndent);
            }
            xMLEmitter.onComment(iMicroComment.getData().toString());
            if (this.m_aSettings.getIndent().isAlign()) {
                xMLEmitter.onContentElementWhitespace(this.m_aSettings.getNewLineString());
            }
        }
    }

    private static void _writeCDATA(@Nonnull XMLEmitter xMLEmitter, @Nonnull IMicroCDATA iMicroCDATA) {
        xMLEmitter.onCDATA(iMicroCDATA.getData().toString());
    }

    private static boolean _isInlineNode(@Nonnull IMicroNode iMicroNode) {
        return iMicroNode.isText() || iMicroNode.isCDATA() || iMicroNode.isEntityReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeElement(@Nonnull XMLEmitter xMLEmitter, @Nullable IMicroNode iMicroNode, @Nullable IMicroNode iMicroNode2, @Nonnull IMicroElement iMicroElement, @Nullable IMicroNode iMicroNode3) {
        String string = iMicroElement.getTagName();
        boolean bl = this.m_aSettings.isEmitNamespaces();
        ICommonsList<IMicroNode> iCommonsList = iMicroElement.getAllChildren();
        boolean bl2 = iMicroElement.hasChildren();
        boolean bl3 = iMicroElement.getParent() != null && iMicroElement.getParent().isDocument();
        boolean bl4 = iMicroNode2 == null || !MicroSerializer._isInlineNode(iMicroNode2) || bl3;
        boolean bl5 = iMicroNode3 == null || !MicroSerializer._isInlineNode(iMicroNode3);
        boolean bl6 = bl2 && !MicroSerializer._isInlineNode(iMicroElement.getFirstChild());
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        this.m_aNSStack.push();
        this.handlePutNamespaceContextPrefixInRoot((Map<QName, String>)commonsLinkedHashMap);
        try {
            String string2 = null;
            String string3 = null;
            if (bl) {
                string2 = StringHelper.getNotNull((String)iMicroElement.getNamespaceURI());
                string3 = this.m_aNSStack.getElementNamespacePrefixToUse(string2, bl3, (Map<QName, String>)commonsLinkedHashMap);
            }
            iMicroElement.forAllAttributes(arg_0 -> this.lambda$_writeElement$0(bl, (ICommonsOrderedMap)commonsLinkedHashMap, arg_0));
            IMicroElement iMicroElement2 = iMicroNode != null && iMicroNode.isElement() ? (IMicroElement)iMicroNode : null;
            String string4 = iMicroElement2 != null ? iMicroElement2.getNamespaceURI() : null;
            String string5 = iMicroElement2 != null ? iMicroElement2.getTagName() : null;
            EXMLSerializeIndent eXMLSerializeIndent = this.m_aSettings.getIndentDeterminator().getIndentOuter(string4, string5, string2, string, (Map<QName, String>)commonsLinkedHashMap, bl2, this.m_aSettings.getIndent());
            if (eXMLSerializeIndent.isIndent() && this.m_aIndent.length() > 0 && bl4) {
                xMLEmitter.onContentElementWhitespace(this.m_aIndent);
            }
            EXMLSerializeBracketMode eXMLSerializeBracketMode = this.m_aSettings.getBracketModeDeterminator().getBracketMode(string2, string, (Map<QName, String>)commonsLinkedHashMap, bl2);
            xMLEmitter.onElementStart(string3, string, (Map<QName, String>)commonsLinkedHashMap, bl2, eXMLSerializeBracketMode);
            if (bl2) {
                EXMLSerializeIndent eXMLSerializeIndent2 = this.m_aSettings.getIndentDeterminator().getIndentOuter(string4, string5, string2, string, (Map<QName, String>)commonsLinkedHashMap, bl2, this.m_aSettings.getIndent());
                if (eXMLSerializeIndent2.isAlign() && bl6) {
                    xMLEmitter.onContentElementWhitespace(this.m_aSettings.getNewLineString());
                }
                String string6 = this.m_aSettings.getIndentationString();
                this.m_aIndent.append(string6);
                if (iCommonsList != null) {
                    this._writeNodeList(xMLEmitter, iMicroElement, (List<IMicroNode>)iCommonsList);
                }
                this.m_aIndent.delete(this.m_aIndent.length() - string6.length(), this.m_aIndent.length());
                if (eXMLSerializeIndent2.isIndent() && this.m_aIndent.length() > 0 && bl6) {
                    xMLEmitter.onContentElementWhitespace(this.m_aIndent);
                }
            }
            xMLEmitter.onElementEnd(string3, string, bl2, eXMLSerializeBracketMode);
            if (eXMLSerializeIndent.isAlign() && bl5) {
                xMLEmitter.onContentElementWhitespace(this.m_aSettings.getNewLineString());
            }
        }
        finally {
            this.m_aNSStack.pop();
        }
    }

    private /* synthetic */ void lambda$_writeElement$0(boolean bl, ICommonsOrderedMap iCommonsOrderedMap, IMicroAttribute iMicroAttribute) {
        IMicroQName iMicroQName = iMicroAttribute.getAttributeQName();
        String string = StringHelper.getNotNull((String)iMicroQName.getNamespaceURI());
        String string2 = iMicroQName.getName();
        String string3 = iMicroAttribute.getAttributeValue();
        String string4 = null;
        if (bl) {
            string4 = this.m_aNSStack.getAttributeNamespacePrefixToUse(string, string2, string3, (Map<QName, String>)iCommonsOrderedMap);
        }
        if (string4 != null) {
            iCommonsOrderedMap.put((Object)iMicroQName.getAsXMLQName(string4), (Object)string3);
        } else {
            iCommonsOrderedMap.put((Object)iMicroQName.getAsXMLQName(), (Object)string3);
        }
    }
}

