/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dynamicdiscovery;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.smp.ESMPTransportProfile;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.phase4.dynamicdiscovery.IAS4EndpointDetailProvider;
import com.helger.phase4.dynamicdiscovery.Phase4SMPException;
import com.helger.phase4.util.Phase4Exception;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.peppol.ISMPServiceMetadataProvider;
import com.helger.smpclient.peppol.SMPClientReadOnly;
import com.helger.xsds.peppol.smp1.EndpointType;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS4EndpointDetailProviderPeppol
implements IAS4EndpointDetailProvider {
    public static final ISMPTransportProfile DEFAULT_TRANSPORT_PROFILE = ESMPTransportProfile.TRANSPORT_PROFILE_PEPPOL_AS4_V2;
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4EndpointDetailProviderPeppol.class);
    private final ISMPServiceMetadataProvider m_aSMPClient;
    private ISMPTransportProfile m_aTP = DEFAULT_TRANSPORT_PROFILE;
    private EndpointType m_aEndpoint;

    public AS4EndpointDetailProviderPeppol(@Nonnull ISMPServiceMetadataProvider iSMPServiceMetadataProvider) {
        ValueEnforcer.notNull((Object)iSMPServiceMetadataProvider, (String)"SMPClient");
        this.m_aSMPClient = iSMPServiceMetadataProvider;
    }

    @Nonnull
    public final ISMPServiceMetadataProvider getServiceMetadataProvider() {
        return this.m_aSMPClient;
    }

    @Nonnull
    public final ISMPTransportProfile getTransportProfile() {
        return this.m_aTP;
    }

    @Nonnull
    public final AS4EndpointDetailProviderPeppol setTransportProfile(@Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        this.m_aTP = iSMPTransportProfile;
        return this;
    }

    @Nullable
    public final EndpointType getEndpoint() {
        return this.m_aEndpoint;
    }

    @Override
    public void init(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws Phase4Exception {
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocTypeID");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcID");
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ReceiverID");
        if (this.m_aEndpoint == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Start performing SMP lookup (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ")");
            }
            try {
                this.m_aEndpoint = this.m_aSMPClient.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, this.m_aTP);
                if (this.m_aEndpoint == null) {
                    throw new Phase4SMPException("Failed to resolve SMP endpoint (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTP.getID() + ")");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Successfully resolved SMP endpoint (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTP.getID() + ")");
                }
            }
            catch (SMPClientException sMPClientException) {
                throw new Phase4SMPException("Failed to resolve SMP endpoint (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTP.getID() + ")", sMPClientException);
            }
        }
    }

    @Override
    @Nullable
    public X509Certificate getReceiverAPCertificate() throws Phase4Exception {
        try {
            return SMPClientReadOnly.getEndpointCertificate((EndpointType)this.m_aEndpoint);
        }
        catch (CertificateException certificateException) {
            throw new Phase4Exception("Failed to extract AP certificate from SMP endpoint: " + this.m_aEndpoint, (Throwable)certificateException);
        }
    }

    @Override
    @Nonnull
    @Nonempty
    public String getReceiverAPEndpointURL() throws Phase4Exception {
        String string = SMPClientReadOnly.getEndpointAddress((EndpointType)this.m_aEndpoint);
        if (StringHelper.hasNoText((String)string)) {
            throw new Phase4Exception("Failed to determine the destination URL from the SMP endpoint: " + this.m_aEndpoint);
        }
        return string;
    }
}

