/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.peppol.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.string.StringHelper;
import com.helger.jaxb.validation.WrappedCollectingValidationEventHandler;
import com.helger.peppol.sbdh.PeppolSBDHDocument;
import com.helger.peppol.sbdh.read.PeppolSBDHDocumentReadException;
import com.helger.peppol.sbdh.read.PeppolSBDHDocumentReader;
import com.helger.peppol.smp.ESMPTransportProfile;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppol.utils.PeppolCertificateHelper;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.factory.SimpleIdentifierFactory;
import com.helger.phase4.attachment.AS4DecompressException;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.IAS4Attachment;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.error.EEbmsError;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.peppol.servlet.IPhase4PeppolIncomingSBDHandlerSPI;
import com.helger.phase4.peppol.servlet.Phase4PeppolClientException;
import com.helger.phase4.peppol.servlet.Phase4PeppolReceiverCheckData;
import com.helger.phase4.peppol.servlet.Phase4PeppolServletConfiguration;
import com.helger.phase4.peppol.servlet.Phase4PeppolServletException;
import com.helger.phase4.servlet.IAS4MessageState;
import com.helger.phase4.servlet.spi.AS4MessageProcessorResult;
import com.helger.phase4.servlet.spi.AS4SignalMessageProcessorResult;
import com.helger.phase4.servlet.spi.IAS4ServletMessageProcessorSPI;
import com.helger.phase4.util.Phase4Exception;
import com.helger.sbdh.SBDMarshaller;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.peppol.ISMPServiceMetadataProvider;
import com.helger.smpclient.peppol.SMPClientReadOnly;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xsds.peppol.smp1.EndpointType;
import com.helper.peppol.reporting.api.PeppolReportingItem;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocument;
import org.w3c.dom.Node;

@IsSPIImplementation
public class Phase4PeppolServletMessageProcessorSPI
implements IAS4ServletMessageProcessorSPI {
    public static final ESMPTransportProfile DEFAULT_TRANSPORT_PROFILE = ESMPTransportProfile.TRANSPORT_PROFILE_PEPPOL_AS4_V2;
    private static final Logger LOGGER = LoggerFactory.getLogger(Phase4PeppolServletMessageProcessorSPI.class);
    private ICommonsList<IPhase4PeppolIncomingSBDHandlerSPI> m_aHandlers;
    private ISMPTransportProfile m_aTransportProfile = DEFAULT_TRANSPORT_PROFILE;
    private Phase4PeppolReceiverCheckData m_aReceiverCheckData;

    @UsedViaReflection
    public Phase4PeppolServletMessageProcessorSPI() {
        this.m_aHandlers = ServiceLoaderHelper.getAllSPIImplementations(IPhase4PeppolIncomingSBDHandlerSPI.class);
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IPhase4PeppolIncomingSBDHandlerSPI> getAllHandler() {
        return (ICommonsList)this.m_aHandlers.getClone();
    }

    @Nonnull
    public final Phase4PeppolServletMessageProcessorSPI setAllHandler(@Nonnull Iterable<? extends IPhase4PeppolIncomingSBDHandlerSPI> iterable) {
        ValueEnforcer.notNull(iterable, (String)"Handlers");
        this.m_aHandlers = new CommonsArrayList(iterable);
        if (this.m_aHandlers.isEmpty()) {
            LOGGER.warn("Phase4PeppolServletMessageProcessorSPI has an empty handler list - this means incoming messages are only checked and afterwards discarded");
        }
        return this;
    }

    @Nonnull
    public final ISMPTransportProfile getTransportProfile() {
        return this.m_aTransportProfile;
    }

    @Nonnull
    public final Phase4PeppolServletMessageProcessorSPI setTransportProfile(@Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        this.m_aTransportProfile = iSMPTransportProfile;
        return this;
    }

    @Nullable
    public final Phase4PeppolReceiverCheckData getReceiverCheckData() {
        return this.m_aReceiverCheckData;
    }

    @Nonnull
    public final Phase4PeppolServletMessageProcessorSPI setReceiverCheckData(@Nullable Phase4PeppolReceiverCheckData phase4PeppolReceiverCheckData) {
        this.m_aReceiverCheckData = phase4PeppolReceiverCheckData;
        return this;
    }

    @Nullable
    private EndpointType _getReceiverEndpoint(@Nonnull String string, @Nonnull ISMPServiceMetadataProvider iSMPServiceMetadataProvider, @Nullable IParticipantIdentifier iParticipantIdentifier, @Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nullable IProcessIdentifier iProcessIdentifier) throws Phase4PeppolServletException {
        if (iParticipantIdentifier == null || iDocumentTypeIdentifier == null || iProcessIdentifier == null) {
            return null;
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string + "Looking up the endpoint of recipient " + iParticipantIdentifier.getURIEncoded() + " for " + iParticipantIdentifier.getURIEncoded() + " and " + iDocumentTypeIdentifier.getURIEncoded() + " and " + iProcessIdentifier.getURIEncoded() + " and " + this.m_aTransportProfile.getID());
            }
            return iSMPServiceMetadataProvider.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, this.m_aTransportProfile);
        }
        catch (Exception exception) {
            throw new Phase4PeppolServletException(string + "Failed to retrieve endpoint of (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTransportProfile.getID() + ")", exception);
        }
    }

    private static void _checkIfReceiverEndpointURLMatches(@Nonnull String string, @Nonnull @Nonempty String string2, @Nonnull EndpointType endpointType) throws Phase4PeppolServletException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string + "Our AP URL is " + string2);
        }
        String string3 = SMPClientReadOnly.getEndpointAddress((EndpointType)endpointType);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string + "Recipient AP URL from SMP is " + string3);
        }
        if (string3 == null || !string3.contains(string2)) {
            String string4 = string + "Internal error: The request is targeted for '" + string3 + "' and is not for us (" + string2 + ")";
            LOGGER.error(string4);
            throw new Phase4PeppolServletException(string4);
        }
    }

    private static void _checkIfEndpointCertificateMatches(@Nonnull String string, @Nonnull X509Certificate x509Certificate, @Nonnull EndpointType endpointType) throws Phase4PeppolServletException {
        String string2 = endpointType.getCertificate();
        X509Certificate x509Certificate2 = null;
        try {
            x509Certificate2 = CertificateHelper.convertStringToCertficate((String)string2);
        }
        catch (CertificateException certificateException) {
            throw new Phase4PeppolServletException(string + "Internal error: Failed to convert looked up endpoint certificate string '" + string2 + "' to an X.509 certificate!", certificateException);
        }
        if (x509Certificate2 == null) {
            throw new Phase4PeppolServletException(string + "No certificate found in looked up endpoint! Is this AP maybe NOT contained in an SMP?");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string + "Conformant recipient certificate present: " + x509Certificate2.toString());
        }
        if (!x509Certificate.getSerialNumber().equals(x509Certificate2.getSerialNumber())) {
            String string3 = string + "Certificate retrieved from SMP lookup (" + x509Certificate2 + ") does not match this APs configured Certificate (" + x509Certificate + ") - different serial numbers - ignoring document";
            LOGGER.error(string3);
            throw new Phase4PeppolServletException(string3);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string + "The certificate of the SMP lookup matches our certificate");
        }
    }

    @Nullable
    public static PeppolReportingItem createPeppolReportingItemForReceivedMessage(@Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull PeppolSBDHDocument peppolSBDHDocument, @Nonnull IAS4MessageState iAS4MessageState, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        OffsetDateTime offsetDateTime;
        ValueEnforcer.notNull((Object)ebms3UserMessage, (String)"UserMessage");
        ValueEnforcer.notNull((Object)peppolSBDHDocument, (String)"PeppolSBD");
        ValueEnforcer.notNull((Object)iAS4MessageState, (String)"State");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"C3ID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"C4CountryCode");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"EndUserID");
        XMLOffsetDateTime xMLOffsetDateTime = ebms3UserMessage.getMessageInfo().getTimestamp();
        if (xMLOffsetDateTime != null) {
            offsetDateTime = xMLOffsetDateTime.getOffset() != null ? xMLOffsetDateTime.toOffsetDateTime() : OffsetDateTime.of(xMLOffsetDateTime.toLocalDateTime(), ZoneOffset.UTC);
        } else {
            LOGGER.warn("Incoming messages does not contain a UserMessage/MessageInfo/Timestamp value. Using current date time");
            offsetDateTime = PDTFactory.getCurrentOffsetDateTime();
        }
        String string4 = PeppolCertificateHelper.getSubjectCN((X509Certificate)iAS4MessageState.getUsedCertificate());
        try {
            return PeppolReportingItem.builder().exchangeDateTime(offsetDateTime).directionReceiving().c2ID(string4).c3ID(string).docTypeID(peppolSBDHDocument.getDocumentTypeAsIdentifier()).processID(peppolSBDHDocument.getProcessAsIdentifier()).transportProtocolPeppolAS4v2().c1CountryCode(peppolSBDHDocument.getCountryC1()).c4CountryCode(string2).endUserID(string3).build();
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.error("Not all mandatory fields are set. Cannot create Peppol Reporting Item", (Throwable)illegalStateException);
            return null;
        }
    }

    @OverrideOnDemand
    protected void afterSuccessfulPeppolProcessing(@Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull PeppolSBDHDocument peppolSBDHDocument, @Nonnull IAS4MessageState iAS4MessageState) {
    }

    @Nonnull
    public AS4MessageProcessorResult processAS4UserMessage(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull IPMode iPMode, @Nullable Node node, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull IAS4MessageState iAS4MessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) {
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        Object object42;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invoking processAS4UserMessage");
        }
        String string = ebms3UserMessage.getMessageInfo().getMessageId();
        String string2 = ebms3UserMessage.getCollaborationInfo().getServiceValue();
        String string3 = ebms3UserMessage.getCollaborationInfo().getAction();
        String string4 = ebms3UserMessage.getCollaborationInfo().getConversationId();
        Locale locale = iAS4MessageState.getLocale();
        String string5 = "[" + string + "] ";
        if (LOGGER.isDebugEnabled()) {
            if (iPMode == null) {
                LOGGER.debug(string5 + "  No Source PMode present");
            } else {
                LOGGER.debug(string5 + "  Source PMode = " + (String)iPMode.getID());
            }
            LOGGER.debug(string5 + "  AS4 Message ID = '" + string + "'");
            LOGGER.debug(string5 + "  AS4 Service = '" + string2 + "'");
            LOGGER.debug(string5 + "  AS4 Action = '" + string3 + "'");
            LOGGER.debug(string5 + "  AS4 ConversationId = '" + string4 + "'");
            if (ebms3UserMessage.getMessageProperties() != null && ebms3UserMessage.getMessageProperties().hasPropertyEntries()) {
                LOGGER.debug(string5 + "  AS4 MessageProperties:");
                for (Ebms3Property ebms3Property : ebms3UserMessage.getMessageProperties().getProperty()) {
                    LOGGER.debug(string5 + "    [" + ebms3Property.getName() + "] = [" + ebms3Property.getValue() + "]");
                }
            } else {
                LOGGER.debug(string5 + "  No AS4 Mesage Properties present");
            }
            if (node == null) {
                LOGGER.debug(string5 + "  No SOAP Body Payload present");
            } else {
                LOGGER.debug(string5 + "  SOAP Body Payload = " + XMLWriter.getNodeAsString((Node)node));
            }
        }
        if (!iAS4MessageState.isSoapDecrypted()) {
            LOGGER.error(string5 + "The received Peppol message was not encrypted properly.");
            iCommonsList2.add((Object)EEbmsError.EBMS_FAILED_DECRYPTION.getAsEbms3Error(locale, iAS4MessageState.getMessageID(), "The received Peppol message was not encrypted properly."));
            return AS4MessageProcessorResult.createFailure();
        }
        if (!iAS4MessageState.isSoapSignatureChecked()) {
            LOGGER.error(string5 + "The received Peppol message was not signed properly.");
            iCommonsList2.add((Object)EEbmsError.EBMS_FAILED_AUTHENTICATION.getAsEbms3Error(locale, iAS4MessageState.getMessageID(), "The received Peppol message was not signed properly."));
            return AS4MessageProcessorResult.createFailure();
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iCommonsList != null) {
            int n = 0;
            for (IAS4Attachment iAS4Attachment : iCommonsList) {
                object42 = new ReadAttachment();
                ((ReadAttachment)object42).m_sID = iAS4Attachment.getId();
                ((ReadAttachment)object42).m_sMimeType = iAS4Attachment.getMimeType();
                ((ReadAttachment)object42).m_sUncompressedMimeType = iAS4Attachment.getUncompressedMimeType();
                ((ReadAttachment)object42).m_aCharset = iAS4Attachment.getCharset();
                ((ReadAttachment)object42).m_eCompressionMode = iAS4Attachment.getCompressionMode();
                try {
                    object3 = iAS4Attachment.getSourceStream();
                    try {
                        object2 = new NonBlockingByteArrayOutputStream();
                        if (StreamHelper.copyInputStreamToOutputStreamAndCloseOS((InputStream)object3, (OutputStream)object2).isSuccess()) {
                            ((ReadAttachment)object42).m_aPayloadBytes = object2.getBufferOrCopy();
                        }
                    }
                    finally {
                        if (object3 != null) {
                            ((InputStream)object3).close();
                        }
                    }
                }
                catch (AS4DecompressException | IOException throwable) {
                    // empty catch block
                }
                if (((ReadAttachment)object42).m_aPayloadBytes == null) {
                    object3 = "Failed to decompress the payload of attachment #" + n;
                    LOGGER.error(string5 + (String)object3);
                    iCommonsList2.add((Object)EEbmsError.EBMS_DECOMPRESSION_FAILURE.getAsEbms3Error(locale, iAS4MessageState.getMessageID(), (String)object3));
                    return AS4MessageProcessorResult.createFailure();
                }
                object3 = new ErrorList();
                ((ReadAttachment)object42).m_aSBDH = (StandardBusinessDocument)new SBDMarshaller().setValidationEventHandler((ValidationEventHandler)new WrappedCollectingValidationEventHandler((ErrorList)object3)).read(((ReadAttachment)object42).m_aPayloadBytes);
                if (n == 0 && ((ReadAttachment)object42).m_aSBDH == null) {
                    if (object3.isEmpty()) {
                        LOGGER.error(string5 + "Failed to read the provided SBDH document");
                        iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.getAsEbms3Error(locale, iAS4MessageState.getMessageID(), "Failed to read the provided SBDH document"));
                    } else {
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            IError iError = (IError)object2.next();
                            String string6 = "Peppol SBDH Issue: " + iError.getAsString(locale);
                            LOGGER.error(string5 + string6);
                            iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.getAsEbms3Error(locale, iAS4MessageState.getMessageID(), string6));
                        }
                    }
                    return AS4MessageProcessorResult.createFailure();
                }
                commonsArrayList.add(object42);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(string5 + "AS4 Attachment " + n + " with ID [" + ((ReadAttachment)object42).m_sID + "] uses [" + ((ReadAttachment)object42).m_sMimeType + (((ReadAttachment)object42).m_sUncompressedMimeType == null ? null : " - uncompressed " + ((ReadAttachment)object42).m_sUncompressedMimeType) + "] and [" + StringHelper.getToString((Object)((ReadAttachment)object42).m_aCharset, (String)"no charset") + "] and length is " + (((ReadAttachment)object42).m_aPayloadBytes == null ? "<error>" : Integer.toString(((ReadAttachment)object42).m_aPayloadBytes.length)) + " bytes" + (((ReadAttachment)object42).m_eCompressionMode == null ? "" : " of compressed payload"));
                }
                ++n;
            }
        }
        if (commonsArrayList.size() != 1) {
            String string7 = "In Peppol exactly one payload attachment is expected. This request has " + commonsArrayList.size() + " attachments";
            LOGGER.error(string5 + string7);
            iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.getAsEbms3Error(locale, iAS4MessageState.getMessageID(), string7));
            return AS4MessageProcessorResult.createFailure();
        }
        ReadAttachment readAttachment = (ReadAttachment)commonsArrayList.getFirst();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string5 + "Now evaluating the SBDH against Peppol rules");
            }
            boolean bl = Phase4PeppolServletConfiguration.isPerformSBDHValueChecks();
            iterator = new PeppolSBDHDocumentReader((IIdentifierFactory)SimpleIdentifierFactory.INSTANCE).setPerformValueChecks(bl).extractData(readAttachment.standardBusinessDocument());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string5 + "The provided SBDH is valid according to Peppol rules, with value checks being " + (bl ? "enabled" : "disabled"));
            }
        }
        catch (PeppolSBDHDocumentReadException peppolSBDHDocumentReadException) {
            object42 = "Failed to extract the Peppol data from SBDH. Technical details: " + ((Object)((Object)peppolSBDHDocumentReadException)).getClass().getName() + " - " + peppolSBDHDocumentReadException.getMessage();
            LOGGER.error(string5 + (String)object42, (Throwable)peppolSBDHDocumentReadException);
            iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.getAsEbms3Error(locale, iAS4MessageState.getMessageID(), (String)object42));
            return AS4MessageProcessorResult.createFailure();
        }
        Object object5 = object = this.m_aReceiverCheckData != null ? this.m_aReceiverCheckData : Phase4PeppolServletConfiguration.getAsReceiverCheckData();
        if (object != null) {
            LOGGER.info(string5 + "Performing checks if the received data is registered in our SMP");
            try {
                object42 = iterator.getReceiverAsIdentifier();
                object3 = iterator.getDocumentTypeAsIdentifier();
                object2 = iterator.getProcessAsIdentifier();
                EndpointType endpointType = this._getReceiverEndpoint(string5, ((Phase4PeppolReceiverCheckData)object).getSMPClient(), (IParticipantIdentifier)object42, (IDocumentTypeIdentifier)object3, (IProcessIdentifier)object2);
                if (endpointType == null) {
                    String string8 = "Failed to resolve SMP endpoint for provided receiver ID (" + (object42 == null ? "null" : object42.getURIEncoded()) + ")/documentType ID (" + (object3 == null ? "null" : object3.getURIEncoded()) + ")/process ID (" + (object2 == null ? "null" : object2.getURIEncoded()) + ")/transport profile (" + this.m_aTransportProfile.getID() + ") - not handling incoming AS4 document";
                    LOGGER.error(string5 + string8);
                    iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.getAsEbms3Error(locale, iAS4MessageState.getMessageID(), string8));
                    return AS4MessageProcessorResult.createFailure();
                }
                Phase4PeppolServletMessageProcessorSPI._checkIfReceiverEndpointURLMatches(string5, ((Phase4PeppolReceiverCheckData)object).getAS4EndpointURL(), endpointType);
                Phase4PeppolServletMessageProcessorSPI._checkIfEndpointCertificateMatches(string5, ((Phase4PeppolReceiverCheckData)object).getAPCertificate(), endpointType);
            }
            catch (Phase4Exception phase4Exception) {
                object3 = "The addressing data contained in the SBDH could not be verified. Technical details: " + ((Object)((Object)phase4Exception)).getClass().getName() + " - " + phase4Exception.getMessage();
                LOGGER.error(string5 + (String)object3, (Throwable)phase4Exception);
                iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.getAsEbms3Error(locale, iAS4MessageState.getMessageID(), (String)object3));
                return AS4MessageProcessorResult.createFailure();
            }
        } else {
            LOGGER.info(string5 + "Endpoint checks for incoming AS4 messages are disabled");
        }
        if (this.m_aHandlers.isEmpty()) {
            LOGGER.error(string5 + "No SPI handler is present - the message is unhandled and discarded!");
        } else {
            for (Object object42 : this.m_aHandlers) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(string5 + "Invoking Peppol handler " + (IPhase4PeppolIncomingSBDHandlerSPI)object42);
                    }
                    object42.handleIncomingSBD(iAS4IncomingMessageMetadata, httpHeaderMap.getClone(), ebms3UserMessage.clone(), readAttachment.payloadBytes(), readAttachment.standardBusinessDocument(), (PeppolSBDHDocument)iterator, iAS4MessageState);
                }
                catch (Phase4PeppolClientException phase4PeppolClientException) {
                    object2 = "Error invoking Peppol handler " + (IPhase4PeppolIncomingSBDHandlerSPI)object42 + ": " + phase4PeppolClientException.getMessage();
                    LOGGER.error(string5 + (String)object2, (Throwable)phase4PeppolClientException);
                    iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.getAsEbms3Error(locale, iAS4MessageState.getMessageID(), (String)object2));
                    return AS4MessageProcessorResult.createFailure();
                }
                catch (Exception exception) {
                    LOGGER.error(string5 + "Error invoking Peppol handler " + (IPhase4PeppolIncomingSBDHandlerSPI)object42, (Throwable)exception);
                    if (!object42.exceptionTranslatesToAS4Error()) continue;
                    object2 = "The incoming Peppol message could not be processed. Technical details: " + exception.getClass().getName() + " - " + exception.getMessage();
                    LOGGER.error(string5 + (String)object2, (Throwable)exception);
                    iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.getAsEbms3Error(locale, iAS4MessageState.getMessageID(), (String)object2));
                    return AS4MessageProcessorResult.createFailure();
                }
            }
            this.afterSuccessfulPeppolProcessing(ebms3UserMessage, (PeppolSBDHDocument)iterator, iAS4MessageState);
        }
        return AS4MessageProcessorResult.createSuccess();
    }

    @Nonnull
    public AS4SignalMessageProcessorResult processAS4SignalMessage(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Ebms3SignalMessage ebms3SignalMessage, @Nullable IPMode iPMode, @Nonnull IAS4MessageState iAS4MessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList) {
        LOGGER.error("Invoking processAS4SignalMessage is not supported");
        throw new UnsupportedOperationException();
    }

    private static final class ReadAttachment {
        private String m_sID;
        private String m_sMimeType;
        private String m_sUncompressedMimeType;
        private Charset m_aCharset;
        private EAS4CompressionMode m_eCompressionMode;
        private byte[] m_aPayloadBytes;
        private StandardBusinessDocument m_aSBDH;

        private ReadAttachment() {
        }

        @Nullable
        public String getID() {
            return this.m_sID;
        }

        @Nullable
        public String getMimeType() {
            return this.m_sMimeType;
        }

        @Nullable
        public String getUncompressedMimeType() {
            return this.m_sUncompressedMimeType;
        }

        @Nullable
        public Charset getCharset() {
            return this.m_aCharset;
        }

        @Nullable
        public EAS4CompressionMode getCompressionMode() {
            return this.m_eCompressionMode;
        }

        @Nonnull
        @ReturnsMutableObject
        public byte[] payloadBytes() {
            return this.m_aPayloadBytes;
        }

        @Nonnull
        @ReturnsMutableObject
        public StandardBusinessDocument standardBusinessDocument() {
            return this.m_aSBDH;
        }
    }
}

