/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.peppol;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.PDTFactory;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.peppol.PeppolValidation2023_05;
import com.helger.phive.peppol.PeppolValidation3_15_0;
import com.helger.phive.peppol.PeppolValidationAUNZ;
import com.helger.phive.peppol.PeppolValidationDirectory;
import com.helger.phive.peppol.PeppolValidationJP;
import com.helger.phive.peppol.PeppolValidationReporting;
import com.helger.phive.peppol.PeppolValidationSG;
import com.helger.phive.xml.schematron.SchematronNamespaceBeautifier;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.ubl21.UBL21NamespaceContext;
import com.helger.xml.namespace.IIterableNamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PeppolValidation {
    @Nonnull
    @Nonempty
    public static String getVersionToUse() {
        LocalDate localDate = PDTFactory.getCurrentLocalDate();
        if (localDate.isBefore(PeppolValidation2023_05.VALID_PER)) {
            return PeppolValidation3_15_0.VERSION_STR;
        }
        return PeppolValidation2023_05.VERSION_STR;
    }

    private PeppolValidation() {
    }

    public static void initStandard(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        SchematronNamespaceBeautifier.addMappings((IIterableNamespaceContext)UBL21NamespaceContext.getInstance());
        PeppolValidation3_15_0.init(iValidationExecutorSetRegistry);
        PeppolValidation2023_05.init(iValidationExecutorSetRegistry);
        PeppolValidationAUNZ.init(iValidationExecutorSetRegistry);
        PeppolValidationSG.init(iValidationExecutorSetRegistry);
        PeppolValidationDirectory.init(iValidationExecutorSetRegistry);
        PeppolValidationReporting.init(iValidationExecutorSetRegistry);
        PeppolValidationJP.init(iValidationExecutorSetRegistry);
    }

    @Nonnull
    @ReturnsMutableObject
    static MapBasedNamespaceContext createUBLNSContext(@Nonnull String string) {
        MapBasedNamespaceContext mapBasedNamespaceContext = UBL21NamespaceContext.getInstance().getClone();
        mapBasedNamespaceContext.addMapping("", string);
        mapBasedNamespaceContext.addMapping("ubl", string);
        return mapBasedNamespaceContext;
    }
}

