/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.peppol;

import com.helger.cii.d16b.CCIID16B;
import com.helger.cii.d16b.CIID16BNamespaceContext;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.version.Version;
import com.helger.diver.api.version.VESID;
import com.helger.phive.api.execute.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSet;
import com.helger.phive.xml.schematron.ValidationExecutorSchematron;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.xsd.ValidationExecutorXSD;
import com.helger.ubl21.UBL21Marshaller;
import com.helger.ubl21.UBL21NamespaceContext;
import com.helger.xml.namespace.IIterableNamespaceContext;
import java.time.LocalDate;
import java.time.Month;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Deprecated
@Immutable
public final class PeppolValidation3_15_0 {
    public static final Version PEPPOL_VALIDATION_ARTEFACT_VERSION = new Version(3, 15, 0);
    public static final String VERSION_STR = PEPPOL_VALIDATION_ARTEFACT_VERSION.getAsString(true);
    public static final LocalDate VALID_PER = PDTFactory.createLocalDate((int)2023, (Month)Month.FEBRUARY, (int)6);
    private static final String GROUP_ID = "eu.peppol.bis3";
    public static final VESID VID_OPENPEPPOL_INVOICE_UBL_V3 = new VESID("eu.peppol.bis3", "invoice", VERSION_STR);
    public static final VESID VID_OPENPEPPOL_CREDIT_NOTE_UBL_V3 = new VESID("eu.peppol.bis3", "creditnote", VERSION_STR);
    public static final VESID VID_OPENPEPPOL_INVOICE_CII_V3 = new VESID("eu.peppol.bis3", "invoice-cii", VERSION_STR);
    public static final VESID VID_OPENPEPPOL_ORDER_V3 = new VESID("eu.peppol.bis3", "order", VERSION_STR);
    public static final VESID VID_OPENPEPPOL_DESPATCH_ADVICE_V3 = new VESID("eu.peppol.bis3", "despatch-advice", VERSION_STR);
    public static final VESID VID_OPENPEPPOL_CATALOGUE_V3 = new VESID("eu.peppol.bis3", "catalogue", VERSION_STR);
    public static final VESID VID_OPENPEPPOL_CATALOGUE_RESPONSE_V3 = new VESID("eu.peppol.bis3", "catalogue-response", VERSION_STR);
    public static final VESID VID_OPENPEPPOL_MLR_V3 = new VESID("eu.peppol.bis3", "mlr", VERSION_STR);
    public static final VESID VID_OPENPEPPOL_ORDER_RESPONSE_V3 = new VESID("eu.peppol.bis3", "order-response", VERSION_STR);
    public static final VESID VID_OPENPEPPOL_PUNCH_OUT_V3 = new VESID("eu.peppol.bis3", "punch-out", VERSION_STR);
    public static final VESID VID_OPENPEPPOL_ORDER_AGREEMENT_V3 = new VESID("eu.peppol.bis3", "order-agreement", VERSION_STR);
    public static final VESID VID_OPENPEPPOL_INVOICE_MESSAGE_RESPONSE_V3 = new VESID("eu.peppol.bis3", "invoice-message-response", VERSION_STR);
    private static final String PREFIX_XSLT = "external/schematron/openpeppol/" + VERSION_STR + "/xslt/";
    public static final IReadableResource INVOICE_UBL_CEN = new ClassPathResource(PREFIX_XSLT + "CEN-EN16931-UBL.xslt", PeppolValidation3_15_0._getCL());
    public static final IReadableResource INVOICE_UBL_PEPPOL = new ClassPathResource(PREFIX_XSLT + "PEPPOL-EN16931-UBL.xslt", PeppolValidation3_15_0._getCL());
    public static final IReadableResource INVOICE_CII_CEN = new ClassPathResource(PREFIX_XSLT + "CEN-EN16931-CII.xslt", PeppolValidation3_15_0._getCL());
    public static final IReadableResource INVOICE_CII_PEPPOL = new ClassPathResource(PREFIX_XSLT + "PEPPOL-EN16931-CII.xslt", PeppolValidation3_15_0._getCL());
    public static final IReadableResource ORDER = new ClassPathResource(PREFIX_XSLT + "PEPPOLBIS-T01.xslt", PeppolValidation3_15_0._getCL());
    public static final IReadableResource DESPATCH_ADVICE = new ClassPathResource(PREFIX_XSLT + "PEPPOLBIS-T16.xslt", PeppolValidation3_15_0._getCL());
    public static final IReadableResource CATALOGUE = new ClassPathResource(PREFIX_XSLT + "PEPPOLBIS-T19.xslt", PeppolValidation3_15_0._getCL());
    public static final IReadableResource CATALOGUE_RESPONSE = new ClassPathResource(PREFIX_XSLT + "PEPPOLBIS-T58.xslt", PeppolValidation3_15_0._getCL());
    public static final IReadableResource MLR = new ClassPathResource(PREFIX_XSLT + "PEPPOLBIS-T71.xslt", PeppolValidation3_15_0._getCL());
    public static final IReadableResource ORDER_RESPONSE = new ClassPathResource(PREFIX_XSLT + "PEPPOLBIS-T76.xslt", PeppolValidation3_15_0._getCL());
    public static final IReadableResource PUNCH_OUT = new ClassPathResource(PREFIX_XSLT + "PEPPOLBIS-T77.xslt", PeppolValidation3_15_0._getCL());
    public static final IReadableResource ORDER_AGREEMENT = new ClassPathResource(PREFIX_XSLT + "PEPPOLBIS-T110.xslt", PeppolValidation3_15_0._getCL());
    public static final IReadableResource INVOICE_MESSAGE_RESPONSE = new ClassPathResource(PREFIX_XSLT + "PEPPOLBIS-T111.xslt", PeppolValidation3_15_0._getCL());

    @Nonnull
    private static ClassLoader _getCL() {
        return PeppolValidation3_15_0.class.getClassLoader();
    }

    private PeppolValidation3_15_0() {
    }

    @Nonnull
    private static ValidationExecutorSchematron _createXsltCII(@Nonnull IReadableResource iReadableResource) {
        return ValidationExecutorSchematron.createXSLT((IReadableResource)iReadableResource, (IIterableNamespaceContext)CIID16BNamespaceContext.getInstance());
    }

    @Nonnull
    private static ValidationExecutorSchematron _createXsltUBL(@Nonnull IReadableResource iReadableResource) {
        return ValidationExecutorSchematron.createXSLT((IReadableResource)iReadableResource, (IIterableNamespaceContext)UBL21NamespaceContext.getInstance());
    }

    public static void init(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        String string = " (" + VERSION_STR + ")";
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_INVOICE_UBL_V3, (String)("OpenPeppol UBL Invoice" + string + " (aka BIS Billing 3.0.14)"), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllInvoiceXSDs()), PeppolValidation3_15_0._createXsltUBL(INVOICE_UBL_CEN), PeppolValidation3_15_0._createXsltUBL(INVOICE_UBL_PEPPOL)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_CREDIT_NOTE_UBL_V3, (String)("OpenPeppol UBL Credit Note" + string + " (aka BIS Billing 3.0.14)"), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCreditNoteXSDs()), PeppolValidation3_15_0._createXsltUBL(INVOICE_UBL_CEN), PeppolValidation3_15_0._createXsltUBL(INVOICE_UBL_PEPPOL)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_INVOICE_CII_V3, (String)("OpenPeppol CII Invoice" + string + " (aka BIS Billing 3.0.14)"), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((IReadableResource)CCIID16B.getXSDResource()), PeppolValidation3_15_0._createXsltCII(INVOICE_CII_CEN), PeppolValidation3_15_0._createXsltCII(INVOICE_CII_PEPPOL)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_ORDER_V3, (String)("OpenPeppol Order" + string + " (aka BIS 3.0.10)"), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllOrderXSDs()), PeppolValidation3_15_0._createXsltUBL(ORDER)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_DESPATCH_ADVICE_V3, (String)("OpenPeppol Despatch Advice" + string + " (aka BIS 3.0.10)"), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllDespatchAdviceXSDs()), PeppolValidation3_15_0._createXsltUBL(DESPATCH_ADVICE)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_CATALOGUE_V3, (String)("OpenPeppol Catalogue" + string + " (aka BIS 3.0.10)"), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCatalogueXSDs()), PeppolValidation3_15_0._createXsltUBL(CATALOGUE)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_CATALOGUE_RESPONSE_V3, (String)("OpenPeppol Catalogue Response" + string + " (aka BIS 3.0.10)"), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllApplicationResponseXSDs()), PeppolValidation3_15_0._createXsltUBL(CATALOGUE_RESPONSE)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_MLR_V3, (String)("OpenPeppol MLR" + string + " (aka BIS 3.0.10)"), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllApplicationResponseXSDs()), PeppolValidation3_15_0._createXsltUBL(MLR)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_ORDER_RESPONSE_V3, (String)("OpenPeppol Order Response" + string + " (aka BIS 3.0.10)"), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllOrderResponseXSDs()), PeppolValidation3_15_0._createXsltUBL(ORDER_RESPONSE)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_PUNCH_OUT_V3, (String)("OpenPeppol Punch Out" + string + " (aka BIS 3.0.10)"), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCatalogueXSDs()), PeppolValidation3_15_0._createXsltUBL(PUNCH_OUT)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_ORDER_AGREEMENT_V3, (String)("OpenPeppol Order Agreement" + string + " (aka BIS 3.0.10)"), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllOrderResponseXSDs()), PeppolValidation3_15_0._createXsltUBL(ORDER_AGREEMENT)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_INVOICE_MESSAGE_RESPONSE_V3, (String)("OpenPeppol Invoice Message Response" + string + " (aka BIS 3.0.10)"), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllApplicationResponseXSDs()), PeppolValidation3_15_0._createXsltUBL(INVOICE_MESSAGE_RESPONSE)}));
    }
}

