/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.peppol;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.diver.api.version.VESID;
import com.helger.phive.api.execute.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSet;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.xsd.ValidationExecutorXSD;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PeppolValidationDirectory {
    private static final String BASE_PATH = "external/schemas/";
    public static final VESID VID_OPENPEPPOL_BUSINESS_CARD_V1 = new VESID("eu.peppol.directory", "businesscard", "1.0.0");
    public static final VESID VID_OPENPEPPOL_BUSINESS_CARD_V2 = new VESID("eu.peppol.directory", "businesscard", "2.0.0");
    public static final VESID VID_OPENPEPPOL_BUSINESS_CARD_V3 = new VESID("eu.peppol.directory", "businesscard", "3.0.0");
    private static final IReadableResource DIRECTORY_V1 = new ClassPathResource("external/schemas/peppol-directory-business-card-20160112.xsd", PeppolValidationDirectory._getCL());
    private static final IReadableResource DIRECTORY_V2 = new ClassPathResource("external/schemas/peppol-directory-business-card-20161123.xsd", PeppolValidationDirectory._getCL());
    private static final IReadableResource DIRECTORY_V3 = new ClassPathResource("external/schemas/peppol-directory-business-card-20180621.xsd", PeppolValidationDirectory._getCL());

    @Nonnull
    private static ClassLoader _getCL() {
        return PeppolValidationDirectory.class.getClassLoader();
    }

    private PeppolValidationDirectory() {
    }

    public static void init(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_BUSINESS_CARD_V1, (String)"Peppol Directory BusinessCard v1", (boolean)false, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((IReadableResource)DIRECTORY_V1)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_BUSINESS_CARD_V2, (String)"Peppol Directory BusinessCard v2", (boolean)false, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((IReadableResource)DIRECTORY_V2)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_BUSINESS_CARD_V3, (String)"Peppol Directory BusinessCard v3", (boolean)false, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((IReadableResource)DIRECTORY_V3)}));
    }
}

