/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.peppol;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.diver.api.version.VESID;
import com.helger.phive.api.execute.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSet;
import com.helger.phive.peppol.PeppolValidation;
import com.helger.phive.xml.schematron.SchematronNamespaceBeautifier;
import com.helger.phive.xml.schematron.ValidationExecutorSchematron;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.xsd.ValidationExecutorXSD;
import com.helger.ubl21.UBL21Marshaller;
import com.helger.xml.namespace.IIterableNamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PeppolValidationJP {
    private static final String BASE_PATH = "external/schematron/jp-pint/";
    public static final VESID VID_OPENPEPPOL_JP_PINT_INVOICE_012 = new VESID("org.peppol.jp.pint", "invoice", "0.1.2");
    public static final VESID VID_OPENPEPPOL_JP_PINT_CREDIT_NOTE_012 = new VESID("org.peppol.jp.pint", "credit-note", "0.1.2");

    @Nonnull
    private static ClassLoader _getCL() {
        return PeppolValidationJP.class.getClassLoader();
    }

    private PeppolValidationJP() {
    }

    public static void init(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        MapBasedNamespaceContext mapBasedNamespaceContext = PeppolValidation.createUBLNSContext(UBL21Marshaller.invoice().getRootElementNamespaceURI());
        MapBasedNamespaceContext mapBasedNamespaceContext2 = PeppolValidation.createUBLNSContext(UBL21Marshaller.creditNote().getRootElementNamespaceURI());
        SchematronNamespaceBeautifier.addMappings((IIterableNamespaceContext)mapBasedNamespaceContext2);
        ClassPathResource classPathResource = new ClassPathResource("external/schematron/jp-pint/0.1.2/xslt/PINT-UBL-validation-preprocessed.xslt", PeppolValidationJP._getCL());
        ClassPathResource classPathResource2 = new ClassPathResource("external/schematron/jp-pint/0.1.2/xslt/PINT-jurisdiction-aligned-rules.xslt", PeppolValidationJP._getCL());
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_JP_PINT_INVOICE_012, (String)"Japan PINT Invoice (UBL) 0.1.2", (boolean)false, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllInvoiceXSDs()), ValidationExecutorSchematron.createXSLT((IReadableResource)classPathResource, (IIterableNamespaceContext)mapBasedNamespaceContext), ValidationExecutorSchematron.createXSLT((IReadableResource)classPathResource2, (IIterableNamespaceContext)mapBasedNamespaceContext)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_JP_PINT_CREDIT_NOTE_012, (String)"Japan PINT Credit Note (UBL) 0.1.2", (boolean)false, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCreditNoteXSDs()), ValidationExecutorSchematron.createXSLT((IReadableResource)classPathResource, (IIterableNamespaceContext)mapBasedNamespaceContext2), ValidationExecutorSchematron.createXSLT((IReadableResource)classPathResource2, (IIterableNamespaceContext)mapBasedNamespaceContext2)}));
    }
}

