/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.peppol;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.diver.api.version.VESID;
import com.helger.phive.api.execute.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSet;
import com.helger.phive.peppol.PeppolValidation;
import com.helger.phive.xml.schematron.SchematronNamespaceBeautifier;
import com.helger.phive.xml.schematron.ValidationExecutorSchematron;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.xsd.ValidationExecutorXSD;
import com.helger.ubl21.UBL21Marshaller;
import com.helger.xml.namespace.IIterableNamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PeppolValidationSG {
    private static final String BASE_PATH = "external/schematron/peppol-sg/";
    @Deprecated
    public static final VESID VID_OPENPEPPOL_BIS3_SG_UBL_INVOICE_102 = new VESID("eu.peppol.bis3.sg.ubl", "invoice", "1.0.2");
    @Deprecated
    public static final VESID VID_OPENPEPPOL_BIS3_SG_UBL_CREDIT_NOTE_102 = new VESID("eu.peppol.bis3.sg.ubl", "creditnote", "1.0.2");
    @Deprecated
    public static final IReadableResource BIS3_BILLING_SG_CEN_102 = new ClassPathResource("external/schematron/peppol-sg/1.0.2/xslt/CEN-EN16931-UBL-SG-Conformant.xslt", PeppolValidationSG._getCL());
    @Deprecated
    public static final IReadableResource BIS3_BILLING_SG_PEPPOL_102 = new ClassPathResource("external/schematron/peppol-sg/1.0.2/xslt/PEPPOL-EN16931-UBL-SG-Conformant.xslt", PeppolValidationSG._getCL());
    public static final VESID VID_OPENPEPPOL_BIS3_SG_UBL_INVOICE_103 = new VESID("eu.peppol.bis3.sg.ubl", "invoice", "1.0.3");
    public static final VESID VID_OPENPEPPOL_BIS3_SG_UBL_CREDIT_NOTE_103 = new VESID("eu.peppol.bis3.sg.ubl", "creditnote", "1.0.3");
    public static final IReadableResource BIS3_BILLING_SG_CEN_103 = new ClassPathResource("external/schematron/peppol-sg/1.0.3/xslt/CEN-EN16931-UBL-SG-Conformant.xslt", PeppolValidationSG._getCL());
    public static final IReadableResource BIS3_BILLING_SG_PEPPOL_103 = new ClassPathResource("external/schematron/peppol-sg/1.0.3/xslt/PEPPOL-EN16931-UBL-SG-Conformant.xslt", PeppolValidationSG._getCL());

    @Nonnull
    private static ClassLoader _getCL() {
        return PeppolValidationSG.class.getClassLoader();
    }

    private PeppolValidationSG() {
    }

    public static void init(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        MapBasedNamespaceContext mapBasedNamespaceContext = PeppolValidation.createUBLNSContext(UBL21Marshaller.invoice().getRootElementNamespaceURI());
        MapBasedNamespaceContext mapBasedNamespaceContext2 = PeppolValidation.createUBLNSContext(UBL21Marshaller.creditNote().getRootElementNamespaceURI());
        SchematronNamespaceBeautifier.addMappings((IIterableNamespaceContext)mapBasedNamespaceContext2);
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_BIS3_SG_UBL_INVOICE_102, (String)"SG Peppol BIS3 Invoice (UBL) 1.0.2", (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllInvoiceXSDs()), ValidationExecutorSchematron.createXSLT((IReadableResource)BIS3_BILLING_SG_CEN_102, (IIterableNamespaceContext)mapBasedNamespaceContext), ValidationExecutorSchematron.createXSLT((IReadableResource)BIS3_BILLING_SG_PEPPOL_102, (IIterableNamespaceContext)mapBasedNamespaceContext)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_BIS3_SG_UBL_CREDIT_NOTE_102, (String)"SG Peppol BIS3 CreditNote (UBL) 1.0.2", (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCreditNoteXSDs()), ValidationExecutorSchematron.createXSLT((IReadableResource)BIS3_BILLING_SG_CEN_102, (IIterableNamespaceContext)mapBasedNamespaceContext2), ValidationExecutorSchematron.createXSLT((IReadableResource)BIS3_BILLING_SG_PEPPOL_102, (IIterableNamespaceContext)mapBasedNamespaceContext2)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_BIS3_SG_UBL_INVOICE_103, (String)"SG Peppol BIS3 Invoice (UBL) 1.0.3", (boolean)false, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllInvoiceXSDs()), ValidationExecutorSchematron.createXSLT((IReadableResource)BIS3_BILLING_SG_CEN_103, (IIterableNamespaceContext)mapBasedNamespaceContext), ValidationExecutorSchematron.createXSLT((IReadableResource)BIS3_BILLING_SG_PEPPOL_103, (IIterableNamespaceContext)mapBasedNamespaceContext)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_OPENPEPPOL_BIS3_SG_UBL_CREDIT_NOTE_103, (String)"SG Peppol BIS3 CreditNote (UBL) 1.0.3", (boolean)false, (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCreditNoteXSDs()), ValidationExecutorSchematron.createXSLT((IReadableResource)BIS3_BILLING_SG_CEN_103, (IIterableNamespaceContext)mapBasedNamespaceContext2), ValidationExecutorSchematron.createXSLT((IReadableResource)BIS3_BILLING_SG_PEPPOL_103, (IIterableNamespaceContext)mapBasedNamespaceContext2)}));
    }
}

