/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.object.tenant;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.photon.security.object.StubObject;
import com.helger.tenancy.AbstractBusinessObject;
import com.helger.tenancy.IBusinessObject;
import com.helger.tenancy.tenant.ITenant;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class Tenant
extends AbstractBusinessObject
implements ITenant {
    public static final ObjectType OT = new ObjectType("tenant");
    private String m_sDisplayName;

    public Tenant(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this(StubObject.createForCurrentUserAndID(string), string2);
    }

    Tenant(@Nonnull StubObject stubObject, @Nonnull @Nonempty String string) {
        super((IBusinessObject)stubObject);
        this.setDisplayName(string);
    }

    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    public EChange setDisplayName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DisplayName");
        if (string.equals(this.m_sDisplayName)) {
            return EChange.UNCHANGED;
        }
        this.m_sDisplayName = string;
        return EChange.CHANGED;
    }

    @Nonnull
    @Nonempty
    public String getAsUIText(Locale locale) {
        return this.getID() + " - " + this.m_sDisplayName;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("DisplayName", (Object)this.m_sDisplayName).getToString();
    }
}

