/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.password.constraint;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.security.password.constraint.EPasswordConstraintText;
import com.helger.photon.security.password.constraint.IPasswordConstraint;
import com.helger.xml.microdom.IMicroElement;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PasswordConstraintMustContainDigit
implements IPasswordConstraint {
    private static final String ATTR_MIN_DIGITS = "mindigits";
    private final int m_nMinDigits;

    public PasswordConstraintMustContainDigit(@Nonnegative int n) {
        this.m_nMinDigits = ValueEnforcer.isGT0((int)n, (String)"MinNumbers");
    }

    @Nonnegative
    public int getMinDigits() {
        return this.m_nMinDigits;
    }

    @Override
    public boolean isPasswordValid(@Nullable String string) {
        int n = 0;
        if (string != null) {
            for (char c : string.toCharArray()) {
                if (!Character.isDigit(c)) continue;
                ++n;
            }
        }
        return n >= this.m_nMinDigits;
    }

    @Override
    @Nullable
    public String getDescription(@Nonnull Locale locale) {
        return EPasswordConstraintText.DESC_MUST_CONTAIN_DIGITS.getDisplayTextWithArgs(locale, new Object[]{this.m_nMinDigits});
    }

    @Override
    public void fillMicroElement(@Nonnull IMicroElement iMicroElement) {
        iMicroElement.setAttribute(ATTR_MIN_DIGITS, this.m_nMinDigits);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordConstraintMustContainDigit passwordConstraintMustContainDigit = (PasswordConstraintMustContainDigit)object;
        return this.m_nMinDigits == passwordConstraintMustContainDigit.m_nMinDigits;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nMinDigits).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("minDigits", this.m_nMinDigits).getToString();
    }
}

