/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.accesstoken;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.base64.Base64;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.string.StringHelper;
import com.helger.photon.security.token.accesstoken.IAccessToken;
import com.helger.photon.security.token.revocation.RevocationStatus;
import java.time.LocalDateTime;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class AccessToken
implements IAccessToken {
    private final String m_sTokenString;
    private final LocalDateTime m_aNotBefore;
    private LocalDateTime m_aNotAfter;
    private final RevocationStatus m_aRevocationStatus;

    public AccessToken(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nullable LocalDateTime localDateTime2, @Nonnull RevocationStatus revocationStatus) {
        this.m_sTokenString = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"TokenString");
        this.m_aNotBefore = (LocalDateTime)ValueEnforcer.notNull((Object)localDateTime, (String)"NotBefore");
        if (localDateTime2 != null) {
            this.setNotAfter(localDateTime2);
        }
        this.m_aRevocationStatus = (RevocationStatus)ValueEnforcer.notNull((Object)revocationStatus, (String)"RevocationStatus");
    }

    @Override
    @Nonnull
    @Nonempty
    public String getTokenString() {
        return this.m_sTokenString;
    }

    @Override
    @Nonnull
    public LocalDateTime getNotBefore() {
        return this.m_aNotBefore;
    }

    @Override
    @Nullable
    public LocalDateTime getNotAfter() {
        return this.m_aNotAfter;
    }

    public void setNotAfter(@Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"NotAfter");
        if (localDateTime.isBefore(this.m_aNotBefore)) {
            throw new IllegalArgumentException("Not after date (" + localDateTime + ") must be >= not before date (" + this.m_aNotBefore + ")");
        }
        this.m_aNotAfter = localDateTime;
    }

    @Override
    public boolean isValidAt(@Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"DateTime");
        if (localDateTime.isBefore(this.m_aNotBefore)) {
            return false;
        }
        return this.m_aNotAfter == null || !localDateTime.isAfter(this.m_aNotAfter);
    }

    @Override
    @Nonnull
    public RevocationStatus getRevocationStatus() {
        return this.m_aRevocationStatus;
    }

    public void markRevoked(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string2) {
        this.m_aRevocationStatus.markRevoked(string, localDateTime, string2);
    }

    @Nonnull
    @Nonempty
    public static String createNewTokenString(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"Bytes");
        ValueEnforcer.isTrue((n % 3 == 0 ? 1 : 0) != 0, (String)"Bytes must be dividable by 3");
        byte[] byArray = new byte[n];
        ThreadLocalRandom.current().nextBytes(byArray);
        return Base64.encodeBytes((byte[])byArray);
    }

    @Nonnull
    public static AccessToken createNewAccessTokenValidFromNow() {
        return AccessToken.createAccessTokenValidFromNow(null);
    }

    @Nonnull
    public static AccessToken createAccessTokenValidFromNow(@Nullable String string) {
        String string2 = StringHelper.hasText((String)string) ? string : AccessToken.createNewTokenString(66);
        return new AccessToken(string2, PDTFactory.getCurrentLocalDateTime(), null, RevocationStatus.createUnrevoked());
    }
}

