/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.user;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.photon.security.object.StubObject;
import com.helger.photon.security.token.accesstoken.AccessToken;
import com.helger.photon.security.token.object.AbstractObjectWithAccessToken;
import com.helger.photon.security.token.user.IUserToken;
import com.helger.photon.security.user.IUser;
import com.helger.tenancy.IBusinessObject;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserToken
extends AbstractObjectWithAccessToken
implements IUserToken {
    public static final ObjectType OT = new ObjectType("usertoken");
    private final IUser m_aUser;
    private String m_sDescription;

    public UserToken(@Nullable String string, @Nullable Map<String, String> map, @Nonnull IUser iUser, @Nullable String string2) {
        this(StubObject.createForCurrentUser(map), (List<AccessToken>)new CommonsArrayList((Object)AccessToken.createAccessTokenValidFromNow(string)), iUser, string2);
    }

    public UserToken(@Nonnull StubObject stubObject, @Nonnull @Nonempty List<AccessToken> list, @Nonnull IUser iUser, @Nullable String string) {
        super((IBusinessObject)stubObject, list);
        this.m_aUser = (IUser)ValueEnforcer.notNull((Object)iUser, (String)"User");
        this.m_sDescription = string;
    }

    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_aUser.getDisplayName();
    }

    @Override
    @Nonnull
    public IUser getUser() {
        return this.m_aUser;
    }

    @Nullable
    public String getDescription() {
        return this.m_sDescription;
    }

    @Nonnull
    public EChange setDescription(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sDescription)) {
            return EChange.UNCHANGED;
        }
        this.m_sDescription = string;
        return EChange.CHANGED;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("User", (Object)this.m_aUser).appendIfNotNull("Description", (Object)this.m_sDescription).getToString();
    }
}

