/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.user;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.commons.text.IHasDescription;
import com.helger.security.authentication.subject.IAuthSubject;
import com.helger.security.password.hash.PasswordHash;
import com.helger.tenancy.IBusinessObject;
import java.time.LocalDateTime;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@MustImplementEqualsAndHashcode
public interface IUser
extends IBusinessObject,
IHasDescription,
IAuthSubject {
    public static final int USER_ID_MAX_LENGTH = 20;
    public static final int LOGIN_NAME_MAX_LENGTH = 200;
    public static final int EMAIL_ADDRESS_MAX_LENGTH = 200;
    public static final int DESIRED_LOCALE_MAX_LENGTH = 20;

    public boolean isAdministrator();

    @Nonnull
    @Nonempty
    public String getLoginName();

    @Nullable
    public String getEmailAddress();

    @Nonnull
    public PasswordHash getPasswordHash();

    @Nullable
    public String getFirstName();

    default public boolean hasFirstName() {
        return StringHelper.hasText((String)this.getFirstName());
    }

    @Nullable
    public String getLastName();

    default public boolean hasLastName() {
        return StringHelper.hasText((String)this.getLastName());
    }

    @Nonnull
    default public String getDisplayName() {
        return StringHelper.getConcatenatedOnDemand((String)this.getFirstName(), (String)" ", (String)this.getLastName());
    }

    @Nullable
    public Locale getDesiredLocale();

    @Nullable
    default public String getDesiredLocaleAsString() {
        Locale locale = this.getDesiredLocale();
        return locale != null ? locale.toString() : null;
    }

    @Nullable
    public LocalDateTime getLastLoginDateTime();

    @Nonnegative
    public int getLoginCount();

    @Nonnegative
    public int getConsecutiveFailedLoginCount();

    default public boolean isEnabled() {
        return !this.isDisabled();
    }

    public boolean isDisabled();
}

