/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.usergroup;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.photon.security.object.StubObject;
import com.helger.photon.security.usergroup.IUserGroup;
import com.helger.tenancy.AbstractBusinessObject;
import com.helger.tenancy.IBusinessObject;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class UserGroup
extends AbstractBusinessObject
implements IUserGroup {
    public static final ObjectType OT = new ObjectType("usergroup");
    private String m_sName;
    private String m_sDescription;
    private final ICommonsSet<String> m_aUserIDs = new CommonsHashSet();
    private final ICommonsSet<String> m_aRoleIDs = new CommonsHashSet();

    public UserGroup(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable Map<String, String> map) {
        this(StubObject.createForCurrentUser(map), string, string2);
    }

    public UserGroup(@Nonnull StubObject stubObject, @Nonnull @Nonempty String string, @Nullable String string2) {
        super((IBusinessObject)stubObject);
        this.setName(string);
        this.setDescription(string2);
    }

    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    public EChange setName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        if (string.equals(this.m_sName)) {
            return EChange.UNCHANGED;
        }
        this.m_sName = string;
        return EChange.CHANGED;
    }

    @Nullable
    public String getDescription() {
        return this.m_sDescription;
    }

    @Nonnull
    public EChange setDescription(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sDescription)) {
            return EChange.UNCHANGED;
        }
        this.m_sDescription = string;
        return EChange.CHANGED;
    }

    @Override
    public boolean hasContainedUsers() {
        return this.m_aUserIDs.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getContainedUserCount() {
        return this.m_aUserIDs.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllContainedUserIDs() {
        return (ICommonsSet)this.m_aUserIDs.getClone();
    }

    @Override
    public boolean containsUserID(String string) {
        return this.m_aUserIDs.contains((Object)string);
    }

    @Nonnull
    public EChange assignUser(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"UserID");
        return EChange.valueOf((boolean)this.m_aUserIDs.add((Object)string));
    }

    @Nonnull
    public EChange assignUsers(@Nullable Iterable<String> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (String string : iterable) {
                eChange = eChange.or((IChangeIndicator)this.assignUser(string));
            }
        }
        return eChange;
    }

    @Nonnull
    public EChange unassignUser(@Nonnull String string) {
        return EChange.valueOf((boolean)this.m_aUserIDs.remove((Object)string));
    }

    @Override
    public boolean hasContainedRoles() {
        return this.m_aRoleIDs.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getContainedRoleCount() {
        return this.m_aRoleIDs.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllContainedRoleIDs() {
        return (ICommonsSet)this.m_aRoleIDs.getClone();
    }

    @Override
    public boolean containsRoleID(String string) {
        return this.m_aRoleIDs.contains((Object)string);
    }

    @Nonnull
    public EChange assignRole(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RoleID");
        return EChange.valueOf((boolean)this.m_aRoleIDs.add((Object)string));
    }

    @Nonnull
    public EChange assignRoles(@Nullable Iterable<String> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (String string : iterable) {
                eChange = eChange.or((IChangeIndicator)this.assignRole(string));
            }
        }
        return eChange;
    }

    @Nonnull
    public EChange unassignRole(@Nonnull String string) {
        return EChange.valueOf((boolean)this.m_aRoleIDs.remove((Object)string));
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Name", (Object)this.m_sName).appendIfNotNull("Description", (Object)this.m_sDescription).append("AssignedUsers", this.m_aUserIDs).append("AssignedRoles", this.m_aRoleIDs).getToString();
    }
}

