/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.string.StringHelper;
import com.helger.photon.security.ESecurityUIText;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.role.IRole;
import com.helger.photon.security.role.IRoleManager;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.usergroup.IUserGroup;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class SecurityHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityHelper.class);
    private static final SecurityHelper INSTANCE = new SecurityHelper();

    private SecurityHelper() {
    }

    public static boolean isCurrentUserAssignedToUserGroup(@Nullable String string) {
        String string2 = LoggedInUserManager.getInstance().getCurrentUserID();
        if (string2 == null) {
            return false;
        }
        return PhotonSecurityManager.getUserGroupMgr().isUserAssignedToUserGroup(string, string2);
    }

    public static boolean hasCurrentUserRole(@Nullable String string) {
        String string2 = LoggedInUserManager.getInstance().getCurrentUserID();
        if (string2 == null) {
            return false;
        }
        return SecurityHelper.hasUserRole(string2, string);
    }

    public static boolean hasUserRole(@Nullable String string, @Nullable String string2) {
        return PhotonSecurityManager.getUserGroupMgr().containsAnyUserGroupWithAssignedUserAndRole(string, string2);
    }

    public static boolean hasUserAllRoles(@Nullable String string, @Nullable Iterable<String> iterable) {
        if (CollectionHelper.isNotEmpty(iterable)) {
            ICommonsList<IUserGroup> iCommonsList = PhotonSecurityManager.getUserGroupMgr().getAllUserGroupsWithAssignedUser(string);
            for (String string2 : iterable) {
                boolean bl = false;
                for (IUserGroup iUserGroup : iCommonsList) {
                    if (!iUserGroup.containsRoleID(string2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllUserRoleIDs(@Nullable String string) {
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        ICommonsList<IUserGroup> iCommonsList = PhotonSecurityManager.getUserGroupMgr().getAllUserGroupsWithAssignedUser(string);
        for (IUserGroup iUserGroup : iCommonsList) {
            commonsHashSet.addAll((Collection)iUserGroup.getAllContainedRoleIDs());
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<IRole> getAllUserRoles(@Nullable String string) {
        IRoleManager iRoleManager = PhotonSecurityManager.getRoleMgr();
        ICommonsSet<String> iCommonsSet = SecurityHelper.getAllUserRoleIDs(string);
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        for (String string2 : iCommonsSet) {
            IRole iRole = iRoleManager.getRoleOfID(string2);
            if (iRole != null) {
                commonsHashSet.add((Object)iRole);
                continue;
            }
            LOGGER.warn("Failed to resolve role with ID '" + string2 + "'");
        }
        return commonsHashSet;
    }

    @Nullable
    public static String getGuestUserDisplayName(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        return ESecurityUIText.GUEST.getDisplayText(locale);
    }

    @Nullable
    public static String getUserDisplayName(@Nullable String string, @Nonnull Locale locale) {
        if (StringHelper.hasNoText((String)string)) {
            return SecurityHelper.getGuestUserDisplayName(locale);
        }
        IUser iUser = PhotonSecurityManager.getUserMgr().getUserOfID(string);
        return iUser == null ? string : SecurityHelper.getUserDisplayName(iUser, locale);
    }

    @Nullable
    public static String getUserDisplayName(@Nullable IUser iUser, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        if (iUser == null) {
            return SecurityHelper.getGuestUserDisplayName(locale);
        }
        String string = iUser.getDisplayName();
        if (StringHelper.hasNoText((String)string)) {
            string = iUser.getLoginName();
        }
        return string;
    }
}

