/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dns.config;

import com.helger.commons.system.SystemProperties;
import com.helger.dns.ip.IPV4Addr;
import java.net.InetAddress;
import java.security.Security;
import java.time.Duration;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class DNSConfig {
    public static final InetAddress DNS_GOOGLE_1 = IPV4Addr.getAsInetAddress(8, 8, 8, 8);
    public static final InetAddress DNS_GOOGLE_2 = IPV4Addr.getAsInetAddress(8, 8, 4, 4);
    public static final InetAddress DNS_CLOUDFLARE_1 = IPV4Addr.getAsInetAddress(1, 1, 1, 1);
    public static final InetAddress DNS_CLOUDFLARE_2 = IPV4Addr.getAsInetAddress(1, 0, 0, 1);
    public static final Duration DEFAULT_RESOLVER_TIMEOUT = Duration.ofSeconds(5L);
    public static final int DEFAULT_RESOLVER_RETRIES = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(DNSConfig.class);
    private static final DNSConfig INSTANCE = new DNSConfig();

    private DNSConfig() {
    }

    public static void setDNSCacheTime(int n) {
        String string = Integer.toString(n);
        try {
            Security.setProperty("networkaddress.cache.ttl", string);
        }
        catch (SecurityException securityException) {
            LOGGER.warn("Failed to set Security property 'networkaddress.cache.ttl' to '" + string + "'");
        }
        try {
            Security.setProperty("networkaddress.cache.negative.ttl", string);
        }
        catch (SecurityException securityException) {
            LOGGER.warn("Failed to set Security property 'networkaddress.cache.negative.ttl' to '" + string + "'");
        }
        SystemProperties.setPropertyValue((String)"disableWSAddressCaching", (n == 0 ? 1 : 0) != 0);
    }

    @Nonnull
    public static Duration getResolverTimeout() {
        return DEFAULT_RESOLVER_TIMEOUT;
    }

    @Nonnegative
    public static int getResolverRetries() {
        return 3;
    }
}

