/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dns.resolve;

import com.helger.dns.ip.IPV4Addr;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Address;

@Immutable
public final class DNSResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DNSResolver.class);
    private static final InetAddress[] IA0 = new InetAddress[0];
    private static final DNSResolver INSTANCE = new DNSResolver();

    private DNSResolver() {
    }

    @Nullable
    public static InetAddress resolveByName(@Nullable String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveByName '" + string + "'");
        }
        InetAddress inetAddress = null;
        if (string != null) {
            try {
                inetAddress = Address.getByName((String)string);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (inetAddress == null) {
            if (string != null) {
                LOGGER.warn("resolveByName '" + string + "' failed");
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveByName '" + string + "' resolved to " + inetAddress);
        }
        return inetAddress;
    }

    @Nonnull
    public static InetAddress[] resolveAllByName(@Nullable String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveAllByName '" + string + "'");
        }
        Object[] objectArray = null;
        if (string != null) {
            try {
                objectArray = Address.getAllByName((String)string);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (objectArray == null) {
            if (string != null) {
                LOGGER.warn("resolveAllByName '" + string + "' failed");
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveAllByName '" + string + "' resolved to " + Arrays.toString(objectArray));
        }
        return objectArray != null ? objectArray : IA0;
    }

    @Nullable
    public static String dnsResolve(@Nonnull String string) {
        InetAddress inetAddress = DNSResolver.resolveByName(string);
        if (inetAddress == null) {
            return null;
        }
        return new IPV4Addr(inetAddress.getAddress()).getAsString();
    }

    @Nonnull
    public static String dnsResolveEx(String string) {
        InetAddress[] inetAddressArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (InetAddress inetAddress : inetAddressArray = DNSResolver.resolveAllByName(string)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(inetAddress.getHostAddress());
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getMyIpAddress() {
        return DNSResolver.getMyIpAddressOrDefault("127.0.0.1");
    }

    @Nullable
    public static String getMyIpAddressOrDefault(@Nullable String string) {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (inetAddress != null) {
                return inetAddress.getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string;
    }
}

