/*
 * Decompiled with CFR 0.152.
 */
package rationals;

import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import rationals.Automaton;
import rationals.DefaultStateFactory;
import rationals.NoSuchStateException;
import rationals.State;
import rationals.Transition;

public class BinaryAutomaton
extends Automaton {
    private Object one;
    private Object zero;
    private BitSet[][] trans;
    private BitSet[][] reverse;
    private int idx;

    public BinaryAutomaton(Object one, Object zero) {
        if (one == zero) {
            throw new IllegalArgumentException("Labels may not be identical");
        }
        this.one = one;
        this.zero = zero;
        this.setStateFactory(new DefaultStateFactory(this));
        this.trans = new BitSet[0][0];
        this.reverse = new BitSet[0][0];
        this.alphabet.add(one);
        this.alphabet.add(zero);
        this.idx = 0;
    }

    public BinaryAutomaton() {
        this(null, new Object());
    }

    public Set accessibleAndCoAccessibleStates() {
        return super.accessibleAndCoAccessibleStates();
    }

    public Set accessibleStates() {
        return super.accessibleStates();
    }

    public Set accessibleStates(Set states) {
        return super.accessibleStates(states);
    }

    public Set accessibleStates(State state) {
        return super.accessibleStates(state);
    }

    @Override
    public State addState(boolean initial, boolean terminal) {
        DefaultStateFactory.DefaultState st = (DefaultStateFactory.DefaultState)super.addState(initial, terminal);
        this.idx = st.i;
        BitSet[][] ntr = new BitSet[this.idx + 1][];
        System.arraycopy(this.trans, 0, ntr, 0, this.idx);
        ntr[this.idx] = new BitSet[2];
        ntr[this.idx][0] = new BitSet();
        ntr[this.idx][1] = new BitSet();
        this.trans = ntr;
        ntr = new BitSet[this.idx + 1][];
        System.arraycopy(this.reverse, 0, ntr, 0, this.idx);
        ntr[this.idx] = new BitSet[2];
        ntr[this.idx][0] = new BitSet();
        ntr[this.idx][1] = new BitSet();
        this.reverse = ntr;
        return st;
    }

    @Override
    public void addTransition(Transition transition) throws NoSuchStateException {
        int i;
        DefaultStateFactory.DefaultState from = (DefaultStateFactory.DefaultState)transition.start();
        DefaultStateFactory.DefaultState to = (DefaultStateFactory.DefaultState)transition.end();
        int n = transition.label() == this.one ? 1 : (i = transition.label() == this.zero ? 0 : -1);
        if (i == -1) {
            throw new IllegalArgumentException("Bad transition label for binary automaton");
        }
        try {
            this.trans[from.i][i].set(to.i);
            this.reverse[to.i][i].set(from.i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchStateException("Invalid from or to state in " + transition);
        }
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public Set delta() {
        return super.delta();
    }

    public Set delta(Set s) {
        return super.delta(s);
    }

    public Set delta(State state, Object label) {
        return super.delta(state, label);
    }

    public Set delta(State state) {
        return super.delta(state);
    }

    public Set deltaFrom(State from, State to) {
        return super.deltaFrom(from, to);
    }

    public Set deltaMinusOne(State state, Object label) {
        return super.deltaMinusOne(state, label);
    }

    public Set deltaMinusOne(State st) {
        return super.deltaMinusOne(st);
    }

    public Object getOne() {
        return this.one;
    }

    public void setOne(Object one) {
        this.one = one;
    }

    public Object getZero() {
        return this.zero;
    }

    public void setZero(Object zero) {
        this.zero = zero;
    }

    class TransitionSet
    implements Set {
        private BitSet from;
        private BitSet[][] trans;
        private BitSet bits;
        private int modcount = 0;
        private int mods = 0;
        private int frombit = -1;
        private int tobit = -1;
        private int lblbit = -1;
        private Iterator it = new Iterator(){

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                return TransitionSet.this.from.nextSetBit(TransitionSet.this.frombit) > -1;
            }

            public Object next() {
                TransitionSet.this.frombit = TransitionSet.this.from.nextSetBit(TransitionSet.this.frombit);
                if (TransitionSet.this.frombit == -1) {
                    throw new NoSuchElementException();
                }
                TransitionSet.this.mods++;
                TransitionSet.this.modcount++;
                if (TransitionSet.this.mods != TransitionSet.this.modcount) {
                    throw new ConcurrentModificationException();
                }
                State from = null;
                ((DefaultStateFactory.DefaultState)from).initial = BinaryAutomaton.this.initials().contains(from);
                ((DefaultStateFactory.DefaultState)from).terminal = BinaryAutomaton.this.terminals().contains(from);
                State to = null;
                ((DefaultStateFactory.DefaultState)to).initial = BinaryAutomaton.this.initials().contains(to);
                ((DefaultStateFactory.DefaultState)to).terminal = BinaryAutomaton.this.terminals().contains(to);
                Transition tr = new Transition(from, TransitionSet.this.lblbit == 1 ? BinaryAutomaton.this.one : BinaryAutomaton.this.zero, to);
                return tr;
            }
        };

        public TransitionSet(BitSet fromSet, BitSet[][] trans) {
            this.from = fromSet;
            this.trans = trans;
        }

        @Override
        public boolean equals(Object obj) {
            TransitionSet ts = (TransitionSet)obj;
            return ts == null ? false : ts.from.equals(this.from) && ts.trans == this.trans;
        }

        @Override
        public int hashCode() {
            return this.from.hashCode() << 9 ^ this.trans.hashCode();
        }

        public String toString() {
            return super.toString();
        }

        @Override
        public int size() {
            return this.bits.cardinality();
        }

        @Override
        public void clear() {
            ++this.modcount;
            this.bits.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.bits.isEmpty();
        }

        @Override
        public Object[] toArray() {
            Object[] ret = new Object[this.size()];
            Iterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                ret[i++] = it.next();
            }
            return ret;
        }

        @Override
        public boolean add(Object o) {
            DefaultStateFactory.DefaultState ds = (DefaultStateFactory.DefaultState)o;
            if (this.bits.get(ds.i)) {
                return false;
            }
            this.bits.set(ds.i);
            ++this.modcount;
            return true;
        }

        @Override
        public boolean contains(Object o) {
            DefaultStateFactory.DefaultState ds = (DefaultStateFactory.DefaultState)o;
            return this.bits.get(ds.i);
        }

        @Override
        public boolean remove(Object o) {
            DefaultStateFactory.DefaultState ds = (DefaultStateFactory.DefaultState)o;
            if (!this.bits.get(ds.i)) {
                return false;
            }
            this.bits.clear(ds.i);
            ++this.modcount;
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            return false;
        }

        @Override
        public boolean containsAll(Collection c) {
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection c) {
            return false;
        }

        @Override
        public Iterator iterator() {
            this.mods = 0;
            this.modcount = 0;
            this.frombit = 0;
            return this.it;
        }

        @Override
        public Object[] toArray(Object[] a) {
            Object[] ret = a.length == this.size() ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
            Iterator it = this.iterator();
            boolean i = false;
            while (it.hasNext()) {
                DefaultStateFactory.DefaultState ds = (DefaultStateFactory.DefaultState)it.next();
                ret[ds.i] = ds;
            }
            return ret;
        }
    }
}

