/*
 * Decompiled with CFR 0.152.
 */
package rationals;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import rationals.Automaton;
import rationals.AutomatonRunListener;
import rationals.AutomatonRunner;
import rationals.DefaultSynchronization;
import rationals.State;
import rationals.StatesTuple;
import rationals.Synchronization;
import rationals.Transition;

public class MixPlay
implements AutomatonRunner {
    private Set explored;
    private static final Random random = new Random();
    private static final Transition[] trmodel = new Transition[0];
    private int upperBound = 1;
    private Object target;
    private List autos;
    private Synchronization sync;
    private Set syncAlphabet;
    private Set listeners = new HashSet();
    private StatesTuple current;

    public MixPlay(List autos) {
        this.autos = autos;
        this.sync = new DefaultSynchronization();
    }

    public MixPlay() {
        this.autos = new ArrayList();
        this.sync = new DefaultSynchronization();
    }

    public void addAutomaton(Automaton a) {
        this.autos.add(a);
    }

    public void reset() {
        this.explored = new HashSet();
        this.target = null;
        Set[] states = new Set[this.autos.size()];
        int i = 0;
        HashSet synalph = new HashSet();
        ArrayList<Set<Object>> alphl = new ArrayList<Set<Object>>();
        for (Automaton a : this.autos) {
            this.upperBound *= a.states().size();
            states[i++] = a.initials();
            Set<Object> alph = a.alphabet();
            alphl.add(alph);
        }
        this.syncAlphabet = this.sync.synchronizable(alphl);
        this.current = new StatesTuple(states);
    }

    public List play(Object target) throws Exception {
        this.target = target;
        ArrayList word = new ArrayList();
        ArrayList tuples = new ArrayList();
        try {
            this.doPlay(word, tuples, this.current);
        }
        catch (MixException mex) {
            this.notify(mex.word, mex.states);
            return mex.word;
        }
        return new ArrayList();
    }

    private void notify(List word, List states) {
        if (this.listeners.isEmpty() || word.isEmpty() || states.isEmpty()) {
            return;
        }
        Iterator wit = word.iterator();
        for (StatesTuple tup : states) {
            Object lt = wit.next();
            int ln = tup.sets.length;
            for (int i = 0; i < ln; ++i) {
                Automaton a = (Automaton)this.autos.get(i);
                HashSet<Transition> trans = new HashSet<Transition>();
                Iterator stit = tup.sets[i].iterator();
                while (stit.hasNext()) {
                    trans.addAll(a.delta((State)stit.next(), lt));
                }
                Iterator lit = this.listeners.iterator();
                while (lit.hasNext()) {
                    ((AutomatonRunListener)lit.next()).fire(a, trans, lt);
                }
            }
        }
    }

    private void doPlay(List word, List tuples, StatesTuple states) throws MixException {
        this.current = states;
        if (!word.isEmpty() && word.get(word.size() - 1).equals(this.target)) {
            throw new MixException(word, tuples);
        }
        if (this.explored.contains(states)) {
            return;
        }
        this.explored.add(states);
        HashSet<Transition> s = new HashSet<Transition>();
        for (int i = 0; i < states.sets.length; ++i) {
            Transition[] trs = ((Automaton)this.autos.get(i)).delta(states.sets[i]).toArray(trmodel);
            int ln = trs.length;
            int k = random.nextInt(ln);
            for (int j = 0; j < ln; ++j) {
                Transition tr = trs[(k + j) % ln];
                if (s.contains(tr)) continue;
                s.add(tr);
                if (!this.checkSynchronizableWith(tr.label(), states) || !this.checkAccessibleWith(tr.label(), states)) continue;
                StatesTuple tup = this.advanceWith(tr.label(), states);
                word.add(tr.label());
                tuples.add(states);
                this.doPlay(word, tuples, tup);
                word.remove(word.size() - 1);
                tuples.remove(tuples.size() - 1);
            }
        }
    }

    private boolean checkSynchronizableWith(Object object, StatesTuple states) {
        if (!this.syncAlphabet.contains(object)) {
            return true;
        }
        for (int i = 0; i < states.sets.length; ++i) {
            Automaton auto = (Automaton)this.autos.get(i);
            if (!this.sync.synchronizeWith(object, auto.alphabet())) continue;
            Set<Transition> s = auto.delta(states.sets[i]);
            Set<State> adv = auto.getStateFactory().stateSet();
            for (Transition tr : s) {
                Object lbl = tr.label();
                if (this.sync.synchronize(lbl, object) == null) continue;
                adv.add(tr.end());
            }
            if (!adv.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean checkAccessibleWith(Object object, StatesTuple states) {
        return true;
    }

    private StatesTuple advanceWith(Object object, StatesTuple states) {
        Set[] nstates = new Set[this.autos.size()];
        for (int i = 0; i < states.sets.length; ++i) {
            Automaton auto = (Automaton)this.autos.get(i);
            Set<Transition> s = auto.delta(states.sets[i]);
            Set adv = auto.getStateFactory().stateSet();
            for (Transition tr : s) {
                Object lbl = tr.label();
                if (this.sync.synchronize(lbl, object) == null) continue;
                adv.add(tr.end());
            }
            nstates[i] = adv.isEmpty() ? states.sets[i] : adv;
        }
        return new StatesTuple(nstates);
    }

    @Override
    public void addRunListener(AutomatonRunListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeRunListener(AutomatonRunListener l) {
        this.listeners.remove(l);
    }

    public Synchronization getSynchronization() {
        return this.sync;
    }

    public void setSynchronization(Synchronization sync) {
        this.sync = sync;
    }

    class MixException
    extends Exception {
        List word;
        List states;

        MixException(List w, List st) {
            this.word = w;
            this.states = st;
        }
    }
}

