/*
 * Decompiled with CFR 0.152.
 */
package rationals.transformations;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import rationals.Automaton;
import rationals.NoSuchStateException;
import rationals.State;
import rationals.Transition;
import rationals.transformations.UnaryTransformation;

public class Accessible
implements UnaryTransformation {
    private State state;

    public Accessible(State s) {
        this.state = s;
    }

    @Override
    public Automaton transform(Automaton a) {
        Set<Transition> trs = a.delta();
        Automaton b = new Automaton();
        HashMap<State, State> stmap = new HashMap<State, State>();
        State ns = b.addState(true, this.state.isTerminal());
        stmap.put(this.state, ns);
        this.explore(this.state, stmap, a, b);
        for (Transition tr : trs) {
            State nstart = (State)stmap.get(tr.start());
            State nend = (State)stmap.get(tr.end());
            if (nstart == null || nend == null) continue;
            try {
                b.addTransition(new Transition(nstart, tr.label(), nend));
            }
            catch (NoSuchStateException e) {
                System.err.println(e.getMessage());
                return null;
            }
        }
        return b;
    }

    private void explore(State curstate, Map stmap, Automaton a, Automaton b) {
        for (Transition tr : a.delta(curstate)) {
            State e = tr.end();
            State ne = (State)stmap.get(e);
            if (ne != null) continue;
            ne = b.addState(e.isInitial(), e.isTerminal());
            stmap.put(e, ne);
            this.explore(e, stmap, a, b);
        }
    }
}

