/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.endpoints;

import com.heroku.sdk.deploy.endpoints.ApiEndpoint;
import com.heroku.sdk.deploy.utils.RestClient;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public class Builds
extends ApiEndpoint {
    private static final String JVM_BUILDPACK_URL = "https://codon-buildpacks.s3.amazonaws.com/buildpacks/heroku/jvm-common.tgz";
    private String blobGetUrl;
    private List<String> buildpackUrls;

    public Builds(String appName, String stackName, String commit, String encodedApiKey, List<String> buildpacks) {
        super(appName, stackName, commit, encodedApiKey);
        if (buildpacks == null || buildpacks.isEmpty()) {
            this.buildpackUrls = Arrays.asList(JVM_BUILDPACK_URL);
        } else {
            this.buildpackUrls = new ArrayList<String>(buildpacks.size());
            for (String buildpack : buildpacks) {
                if (buildpack.equals("jvm-common")) {
                    this.buildpackUrls.add(JVM_BUILDPACK_URL);
                    continue;
                }
                this.buildpackUrls.add(buildpack);
            }
        }
    }

    public Map createSource() throws IOException {
        String urlStr = "https://api.heroku.com/apps/" + URLEncoder.encode(this.appName, "UTF-8") + "/sources";
        Map sourceResponse = RestClient.post(urlStr, this.headers);
        Map blobJson = (Map)sourceResponse.get("source_blob");
        this.blobUrl = (String)blobJson.get("put_url");
        this.blobGetUrl = (String)blobJson.get("get_url");
        return sourceResponse;
    }

    public Map build(RestClient.OutputLogger logger) throws IOException, InterruptedException {
        String data;
        if (this.blobGetUrl == null) {
            throw new IllegalStateException("Source must be created before releasing!");
        }
        String urlStr = "https://api.heroku.com/apps/" + this.appName + "/builds";
        Map buildResponse = RestClient.post(urlStr, data = "{\"buildpacks\":" + this.getBuildpacksJson() + ", " + "\"source_blob\":{\"url\":\"" + StringEscapeUtils.escapeJson((String)this.blobGetUrl) + "\",\"version\":\"" + StringEscapeUtils.escapeJson((String)this.commit) + "\"}}", this.headers);
        String outputUrl = (String)buildResponse.get("output_stream_url");
        if (outputUrl != null) {
            RestClient.get(outputUrl, this.headers, logger);
        }
        Thread.sleep(2000L);
        return this.getBuildInfo((String)buildResponse.get("id"));
    }

    public Map getBuildInfo(String buildId) throws IOException {
        String buildStatusUrlStr = "https://api.heroku.com/apps/" + this.appName + "/builds/" + buildId;
        return RestClient.get(buildStatusUrlStr, this.headers);
    }

    public String getBuildpacksJson() {
        String buildpacksString = "";
        for (String url : this.buildpackUrls) {
            buildpacksString = buildpacksString + ",{\"url\":\"" + StringEscapeUtils.escapeJson((String)url) + "\"}";
        }
        return buildpacksString.replaceFirst(",", "[") + "]";
    }
}

