/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.mssmb2.messages;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.mssmb2.SMB2ShareCapabilities;
import com.hierynomus.mssmb2.SMB2ShareFlags;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smb.SMBBuffer;
import java.util.Set;

public class SMB2TreeConnectResponse
extends SMB2Packet {
    private byte shareType;
    private Set<SMB2ShareFlags> shareFlags;
    private Set<SMB2ShareCapabilities> capabilities;
    private Set<AccessMask> maximalAccess;

    @Override
    protected void readMessage(SMBBuffer buffer) throws Buffer.BufferException {
        buffer.skip(2);
        this.shareType = buffer.readByte();
        buffer.readByte();
        this.shareFlags = EnumWithValue.EnumUtils.toEnumSet(buffer.readUInt32(), SMB2ShareFlags.class);
        this.capabilities = EnumWithValue.EnumUtils.toEnumSet(buffer.readUInt32(), SMB2ShareCapabilities.class);
        this.maximalAccess = EnumWithValue.EnumUtils.toEnumSet(buffer.readUInt32(), AccessMask.class);
    }

    public void setShareType(byte shareType) {
        this.shareType = shareType;
    }

    public boolean isDiskShare() {
        return this.shareType == 1;
    }

    public boolean isNamedPipe() {
        return this.shareType == 2;
    }

    public boolean isPrinterShare() {
        return this.shareType == 3;
    }

    public Set<SMB2ShareFlags> getShareFlags() {
        return this.shareFlags;
    }

    public void setShareFlags(Set<SMB2ShareFlags> shareFlags) {
        this.shareFlags = shareFlags;
    }

    public Set<SMB2ShareCapabilities> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Set<SMB2ShareCapabilities> capabilities) {
        this.capabilities = capabilities;
    }

    public Set<AccessMask> getMaximalAccess() {
        return this.maximalAccess;
    }
}

