/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.ntlm.av;

import com.hierynomus.ntlm.av.AvId;
import com.hierynomus.ntlm.av.AvPair;
import com.hierynomus.ntlm.av.AvPairChannelBindings;
import com.hierynomus.ntlm.av.AvPairEnd;
import com.hierynomus.ntlm.av.AvPairFlags;
import com.hierynomus.ntlm.av.AvPairSingleHost;
import com.hierynomus.ntlm.av.AvPairString;
import com.hierynomus.ntlm.av.AvPairTimestamp;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;

public class AvPairFactory {
    public static AvPair<?> read(Buffer<?> buffer) throws Buffer.BufferException {
        int l = buffer.readUInt16();
        AvId avId = EnumWithValue.EnumUtils.valueOf(l, AvId.class, null);
        if (avId == null) {
            throw new IllegalStateException("Encountered unknown AvId: " + l);
        }
        switch (avId) {
            case MsvAvEOL: {
                return new AvPairEnd().read(buffer);
            }
            case MsvAvNbComputerName: 
            case MsvAvNbDomainName: 
            case MsvAvDnsComputerName: 
            case MsvAvDnsDomainName: 
            case MsvAvDnsTreeName: 
            case MsvAvTargetName: {
                return new AvPairString(avId).read((Buffer)buffer);
            }
            case MsvAvFlags: {
                return new AvPairFlags().read(buffer);
            }
            case MsvAvTimestamp: {
                return new AvPairTimestamp().read(buffer);
            }
            case MsvAvSingleHost: {
                return new AvPairSingleHost().read((Buffer)buffer);
            }
            case MsvAvChannelBindings: {
                return new AvPairChannelBindings().read(buffer);
            }
        }
        throw new IllegalStateException("Encountered unhandled AvId: " + avId);
    }
}

