/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.signature;

import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import net.schmizz.sshj.common.SSHRuntimeException;

public class Ed25519PublicKey
extends EdDSAPublicKey {
    public Ed25519PublicKey(EdDSAPublicKeySpec spec) {
        super(spec);
        EdDSANamedCurveSpec ed25519 = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
        if (!spec.getParams().getCurve().equals(ed25519.getCurve())) {
            throw new SSHRuntimeException("Cannot create Ed25519 Public Key from wrong spec");
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof Ed25519PublicKey)) {
            return false;
        }
        Ed25519PublicKey otherKey = (Ed25519PublicKey)((Object)other);
        return Arrays.equals(this.getAbyte(), otherKey.getAbyte());
    }

    public int hashCode() {
        return this.getA().hashCode();
    }
}

