/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.forwarded;

import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.channel.AbstractChannel;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.OpenFailException;
import net.schmizz.sshj.transport.TransportException;

public abstract class AbstractForwardedChannel
extends AbstractChannel
implements Channel.Forwarded {
    protected final String origIP;
    protected final int origPort;

    protected AbstractForwardedChannel(Connection conn, String type, int recipient, long remoteWinSize, long remoteMaxPacketSize, String origIP, int origPort) {
        super(conn, type);
        this.origIP = origIP;
        this.origPort = origPort;
        this.init(recipient, remoteWinSize, remoteMaxPacketSize);
    }

    @Override
    public void confirm() throws TransportException {
        this.log.debug("Confirming `{}` channel #{}", (Object)this.getType(), (Object)this.getID());
        this.conn.attach(this);
        this.trans.write((SSHPacket)((SSHPacket)((SSHPacket)this.newBuffer(Message.CHANNEL_OPEN_CONFIRMATION).putUInt32(this.getID())).putUInt32(this.getLocalWinSize())).putUInt32(this.getLocalMaxPacketSize()));
        this.openEvent.set();
    }

    @Override
    public void reject(OpenFailException.Reason reason, String message) throws TransportException {
        this.log.debug("Rejecting `{}` channel: {}", (Object)this.getType(), (Object)message);
        this.conn.sendOpenFailure(this.getRecipient(), reason, message);
    }

    @Override
    public String getOriginatorIP() {
        return this.origIP;
    }

    @Override
    public int getOriginatorPort() {
        return this.origPort;
    }
}

