/*
 * Decompiled with CFR 0.152.
 */
package com.holdenkarau.spark.testing;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.BindException;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.eclipse.jetty.util.MultiException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Utils$
implements org.apache.spark.Logging {
    public static Utils$ MODULE$;
    private final HashSet<String> shutdownDeletePaths;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Utils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HashSet<String> shutdownDeletePaths() {
        return this.shutdownDeletePaths;
    }

    public void shutDownCleanUp() {
        this.shutdownDeletePaths().foreach((Function1 & Serializable & scala.Serializable)dirPath -> {
            Utils$.MODULE$.cleanupPath(dirPath);
            return BoxedUnit.UNIT;
        });
        this.shutdownDeletePaths().foreach((Function1 & Serializable & scala.Serializable)dirPath -> {
            Utils$.MODULE$.cleanupPath(dirPath);
            return BoxedUnit.UNIT;
        });
    }

    private void cleanupPath(String dirPath) {
        try {
            this.deleteRecursively(new File(dirPath));
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)"Exception during cleanup");
        }
    }

    public boolean isSymlink(File file) {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        File fileInCanonicalDir = file.getParent() == null ? file : new File(file.getParentFile().getCanonicalFile(), file.getName());
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    private Seq<File> listFilesSafely(File file) {
        Nil$ nil$;
        if (file.exists()) {
            File[] files = file.listFiles();
            if (files == null) {
                throw new IOException(new StringBuilder(30).append("Failed to list files for dir: ").append(file).toString());
            }
            nil$ = Predef$.MODULE$.wrapRefArray((Object[])files);
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public void deleteRecursively(File file) {
        block9: {
            if (file != null) {
                try {
                    if (!file.isDirectory() || this.isSymlink(file)) break block9;
                    ObjectRef savedIOException = ObjectRef.create(null);
                    this.listFilesSafely(file).foreach((Function1 & Serializable & scala.Serializable)child -> {
                        Utils$.$anonfun$deleteRecursively$1(savedIOException, child);
                        return BoxedUnit.UNIT;
                    });
                    if ((IOException)savedIOException.elem != null) {
                        throw (IOException)savedIOException.elem;
                    }
                    HashSet<String> hashSet = this.shutdownDeletePaths();
                    synchronized (hashSet) {
                        this.shutdownDeletePaths().remove((Object)file.getAbsolutePath());
                    }
                }
                finally {
                    if (!file.delete() && file.exists()) {
                        throw new IOException(new StringBuilder(18).append("Failed to delete: ").append(file.getAbsolutePath()).toString());
                    }
                }
            }
        }
    }

    public void registerShutdownDeleteDir(File file) {
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.shutdownDeletePaths();
        synchronized (hashSet) {
            this.shutdownDeletePaths().$plus$eq((Object)absolutePath);
        }
    }

    public File createDirectory(String root) {
        int attempts = 0;
        int maxAttempts = 10;
        File dir = null;
        while (dir == null) {
            if (++attempts > maxAttempts) {
                throw new IOException(new StringBuilder(49).append("Failed to create a temp directory (under ").append(root).append(") after ").append(maxAttempts).toString());
            }
            try {
                dir = new File(root, new StringBuilder(6).append("spark-").append(UUID.randomUUID().toString()).toString());
                if (!dir.exists() && dir.mkdirs()) continue;
                dir = null;
            }
            catch (SecurityException e) {
                dir = null;
            }
        }
        return dir;
    }

    /*
     * WARNING - void declaration
     */
    public File createTempDir(String root) {
        void var2_2;
        File dir = this.createDirectory(root);
        this.registerShutdownDeleteDir(dir);
        return var2_2;
    }

    public String createTempDir$default$1() {
        return System.getProperty("java.io.tmpdir");
    }

    public <T> Tuple2<T, Object> startServiceOnPort(int startPort, Function1<Object, Tuple2<T, Object>> startService, SparkConf conf, String serviceName) {
        Object object = new Object();
        try {
            Predef$.MODULE$.require(startPort == 0 || 1024 <= startPort && startPort < 65536, (Function0 & Serializable & scala.Serializable)() -> "startPort should be between 1024 and 65535 (inclusive), or 0 for a random free port.");
            String serviceString = serviceName.isEmpty() ? "" : new StringBuilder(3).append(" '").append(serviceName).append("'").toString();
            int maxRetries = 100;
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxRetries).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
                int tryPort = startPort == 0 ? startPort : (startPort + offset - 1024) % 64512 + 1024;
                try {
                    Tuple2 tuple2 = (Tuple2)startService.apply((Object)BoxesRunTime.boxToInteger((int)tryPort));
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object service = tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2(service, (Object)BoxesRunTime.boxToInteger((int)port));
                    Tuple2 tuple23 = tuple22;
                    Object service2 = tuple23._1();
                    int port2 = tuple23._2$mcI$sp();
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Successfully started service").append(serviceString).append(" on port ").append(port2).append(".").toString());
                    throw new NonLocalReturnControl(object, (Object)new Tuple2(service2, (Object)BoxesRunTime.boxToInteger((int)port2)));
                }
                catch (Throwable throwable) {
                    Exception exception;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof Exception && MODULE$.isBindCollision(exception = (Exception)throwable2)) {
                        if (offset >= maxRetries) {
                            String exceptionMessage = new StringBuilder(23).append(exception.getMessage()).append(": Service").append(serviceString).append(" failed after ").append(new StringBuilder(9).append(maxRetries).append(" retries!").toString()).toString();
                            BindException exception2 = new BindException(exceptionMessage);
                            exception2.setStackTrace(exception.getStackTrace());
                            throw exception2;
                        }
                    } else {
                        throw throwable;
                    }
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Service").append(serviceString).append(" could not bind on port ").append(tryPort).append(". ").append(new StringBuilder(17).append("Attempting port ").append(tryPort + 1).append(".").toString()).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            });
            throw new SparkException(new StringBuilder(32).append("Failed to start service").append(serviceString).append(" on port ").append(startPort).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple2)ex.value();
        }
    }

    public <T> String startServiceOnPort$default$4() {
        return "";
    }

    public boolean isBindCollision(Throwable exception2) {
        boolean bl;
        block4: {
            while (true) {
                Throwable throwable;
                if ((throwable = exception2) instanceof BindException) {
                    BindException bindException = (BindException)throwable;
                    if (bindException.getMessage() != null) {
                        return true;
                    }
                    exception2 = bindException.getCause();
                    continue;
                }
                if (throwable instanceof MultiException) {
                    MultiException multiException = (MultiException)throwable;
                    bl = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(multiException.getThrowables()).exists((Function1 & Serializable & scala.Serializable)exception -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isBindCollision(exception)));
                    break block4;
                }
                if (!(throwable instanceof Exception)) break;
                Exception exception3 = (Exception)throwable;
                exception2 = exception3.getCause();
            }
            bl = false;
        }
        return bl;
    }

    public <T> ClassTag<T> fakeClassTag() {
        return ClassTag$.MODULE$.AnyRef();
    }

    public static final /* synthetic */ void $anonfun$deleteRecursively$1(ObjectRef savedIOException$1, File child) {
        try {
            MODULE$.deleteRecursively(child);
        }
        catch (IOException ioe) {
            savedIOException$1.elem = ioe;
        }
    }

    private Utils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.shutdownDeletePaths = new HashSet();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Utils$.MODULE$.shutDownCleanUp();
            }
        });
    }
}

