/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main.iterator;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.Binding1;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.engine.main.QC;
import com.hp.hpl.jena.sparql.lib.iterator.NullIterator;
import com.hp.hpl.jena.sparql.lib.iterator.SingletonIterator;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryIterGraph
extends QueryIterRepeatApply {
    protected OpGraph opGraph;

    public QueryIterGraph(QueryIterator input, OpGraph opGraph, ExecutionContext context) {
        super(input, context);
        this.opGraph = opGraph;
    }

    @Override
    protected QueryIterator nextStage(Binding outerBinding) {
        DatasetGraph ds = this.getExecContext().getDataset();
        Iterator<Node> graphNameNodes = QueryIterGraph.makeSources(ds, outerBinding, this.opGraph.getNode());
        QueryIterGraphInner current = new QueryIterGraphInner(outerBinding, graphNameNodes, this.opGraph, this.getExecContext());
        return current;
    }

    private static Node resolve(Binding b, Node n) {
        if (!n.isVariable()) {
            return n;
        }
        return b.get(Var.alloc(n));
    }

    protected static Iterator<Node> makeSources(DatasetGraph data, Binding b, Node graphVar) {
        Node n2 = QueryIterGraph.resolve(b, graphVar);
        if (n2 != null && !n2.isURI()) {
            return new NullIterator<Node>();
        }
        if (n2 == null) {
            return data.listGraphNodes();
        }
        return new SingletonIterator<Node>(n2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class QueryIterGraphInner
    extends QueryIter {
        protected Binding parentBinding;
        protected Iterator<Node> graphNames;
        protected OpGraph opGraph;
        protected QueryIterator subIter = null;

        protected QueryIterGraphInner(Binding parent, Iterator<Node> graphNames, OpGraph opGraph, ExecutionContext execCxt) {
            super(execCxt);
            this.parentBinding = parent;
            this.graphNames = graphNames;
            this.opGraph = opGraph;
        }

        @Override
        protected boolean hasNextBinding() {
            do {
                if (this.subIter == null) {
                    this.subIter = this.nextIterator();
                }
                if (this.subIter == null) {
                    return false;
                }
                if (this.subIter.hasNext()) {
                    return true;
                }
                this.subIter.close();
                this.subIter = this.nextIterator();
            } while (this.subIter != null);
            return false;
        }

        @Override
        protected Binding moveToNextBinding() {
            if (this.subIter == null) {
                throw new NoSuchElementException(Utils.className(this) + ".moveToNextBinding");
            }
            return this.subIter.nextBinding();
        }

        @Override
        protected void closeIterator() {
            if (this.subIter != null) {
                this.subIter.close();
            }
            this.subIter = null;
        }

        protected QueryIterator nextIterator() {
            if (!this.graphNames.hasNext()) {
                return null;
            }
            Node gn = this.graphNames.next();
            Binding b = this.parentBinding;
            if (Var.isVar(this.opGraph.getNode())) {
                b = new Binding1(b, Var.alloc(this.opGraph.getNode()), gn);
            }
            QueryIterator qIter = QueryIterGraphInner.buildIterator(b, gn, this.opGraph, this.getExecContext());
            return qIter;
        }

        protected static QueryIterator buildIterator(Binding binding, Node graphNode, OpGraph opGraph, ExecutionContext outerCxt) {
            if (!graphNode.isURI()) {
                throw new ARQInternalErrorException("QueryIterGraphInner.buildIterator");
            }
            Op op = QC.substitute(opGraph.getSubOp(), binding);
            Graph g = outerCxt.getDataset().getGraph(graphNode);
            if (g == null) {
                return null;
            }
            ExecutionContext cxt2 = new ExecutionContext(outerCxt, g);
            QueryIterSingleton subInput = new QueryIterSingleton(binding, cxt2);
            return QC.execute(op, subInput, cxt2);
        }
    }
}

