/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lib.cache;

import com.hp.hpl.jena.sparql.lib.ActionKeyValue;
import com.hp.hpl.jena.sparql.lib.Cache;
import com.hp.hpl.jena.sparql.lib.iterator.SingletonIterator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache1<K, V>
implements Cache<K, V> {
    private ActionKeyValue<K, V> dropHandler = null;
    private K cacheKey;
    private V cacheValue;

    public Cache1() {
        this.clear();
    }

    @Override
    public boolean containsKey(K key) {
        if (this.cacheKey == null) {
            return false;
        }
        return this.cacheKey.equals(key);
    }

    @Override
    public V get(K key) {
        if (this.cacheKey == null) {
            return null;
        }
        if (this.cacheKey.equals(key)) {
            return this.cacheValue;
        }
        return null;
    }

    @Override
    public void clear() {
        this.cacheKey = null;
        this.cacheValue = null;
    }

    @Override
    public boolean isEmpty() {
        return this.cacheKey == null;
    }

    @Override
    public Iterator<K> keys() {
        return new SingletonIterator<K>(this.cacheKey);
    }

    @Override
    public V put(K key, V thing) {
        V old = this.cacheValue;
        this.cacheKey = key;
        this.cacheValue = thing;
        if (old != null && old.equals(this.cacheValue)) {
            this.drop(key, old);
        }
        return old;
    }

    @Override
    public boolean remove(K key) {
        if (this.cacheKey == null) {
            return false;
        }
        if (this.cacheKey.equals(key)) {
            this.drop(this.cacheKey, this.cacheValue);
            this.clear();
            return true;
        }
        return false;
    }

    @Override
    public void setDropHandler(ActionKeyValue<K, V> dropHandler) {
        this.dropHandler = dropHandler;
    }

    private void drop(K key, V thing) {
        if (this.dropHandler != null) {
            this.dropHandler.apply(key, thing);
        }
    }

    @Override
    public long size() {
        return this.cacheKey == null ? 0L : 1L;
    }
}

