/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.QuerySolutionBase;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySolutionMap
extends QuerySolutionBase {
    private Map<String, RDFNode> map = new HashMap<String, RDFNode>();

    public void add(String name, RDFNode node) {
        this.map.put(Var.canonical(name), node);
    }

    @Override
    protected RDFNode _get(String varName) {
        return this.map.get(Var.canonical(varName));
    }

    @Override
    protected boolean _contains(String varName) {
        return this.map.containsKey(Var.canonical(varName));
    }

    @Override
    public Iterator<String> varNames() {
        return this.map.keySet().iterator();
    }

    public void addAll(QuerySolutionMap other) {
        this.map.putAll(other.map);
    }

    public void addAll(QuerySolution other) {
        Iterator<String> iter = other.varNames();
        while (iter.hasNext()) {
            String vName = iter.next();
            RDFNode rdfNode = other.get(vName);
            this.map.put(vName, rdfNode);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        String tmp = "";
        String sep = "";
        Iterator<String> iter = this.varNames();
        while (iter.hasNext()) {
            String varName = iter.next();
            RDFNode n = this._get(varName);
            String nStr = FmtUtils.stringForRDFNode(n);
            tmp = tmp + sep + "( ?" + varName + ", " + nStr + " )";
        }
        return tmp;
    }
}

