/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQNotImplemented;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.resultset.CSVOutput;
import com.hp.hpl.jena.sparql.resultset.JSONOutput;
import com.hp.hpl.jena.sparql.resultset.RDFOutput;
import com.hp.hpl.jena.sparql.resultset.ResultSetFormat;
import com.hp.hpl.jena.sparql.resultset.TSVOutput;
import com.hp.hpl.jena.sparql.resultset.TextOutput;
import com.hp.hpl.jena.sparql.resultset.XMLOutput;
import com.hp.hpl.jena.sparql.resultset.XMLOutputASK;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetFormatter {
    private ResultSetFormatter() {
    }

    public static void out(ResultSet qresults) {
        ResultSetFormatter.out((OutputStream)System.out, qresults);
    }

    public static void out(OutputStream out, ResultSet qresults) {
        ResultSetFormatter.out(out, qresults, (PrefixMapping)null);
    }

    public static void out(ResultSet qresults, Query query2) {
        ResultSetFormatter.out((OutputStream)System.out, qresults, query2);
    }

    public static void out(ResultSet qresults, Prologue prologue) {
        ResultSetFormatter.out((OutputStream)System.out, qresults, prologue);
    }

    public static void out(ResultSet qresults, PrefixMapping pmap) {
        ResultSetFormatter.out((OutputStream)System.out, qresults, pmap);
    }

    public static void out(OutputStream out, ResultSet qresults, PrefixMapping pmap) {
        TextOutput tFmt = new TextOutput(pmap);
        tFmt.format(out, qresults);
    }

    public static void out(OutputStream out, ResultSet qresults, Prologue prologue) {
        TextOutput tFmt = new TextOutput(prologue);
        tFmt.format(out, qresults);
    }

    public static void out(boolean answer) {
        ResultSetFormatter.out((OutputStream)System.out, answer);
    }

    public static void out(OutputStream out, boolean answer) {
        TextOutput tFmt = new TextOutput((SerializationContext)null);
        tFmt.format(out, answer);
    }

    public static String asText(ResultSet qresults) {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.out((OutputStream)arr, qresults);
        try {
            return new String(arr.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            ALog.warn(ResultSetFormatter.class, "UnsupportedEncodingException");
            return null;
        }
    }

    public static String asText(ResultSet qresults, Prologue prologue) {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.out((OutputStream)arr, qresults, prologue);
        try {
            return new String(arr.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            ALog.warn(ResultSetFormatter.class, "UnsupportedEncodingException");
            return null;
        }
    }

    public static int consume(ResultSet resultSet) {
        int count = 0;
        while (resultSet.hasNext()) {
            QuerySolution result = resultSet.nextSolution();
            Iterator<String> iter = result.varNames();
            while (iter.hasNext()) {
                String vn = iter.next();
                RDFNode n = result.get(vn);
            }
            ++count;
        }
        return count;
    }

    public static List<QuerySolution> toList(ResultSet resultSet) {
        ArrayList<QuerySolution> list = new ArrayList<QuerySolution>();
        while (resultSet.hasNext()) {
            QuerySolution result = resultSet.nextSolution();
            list.add(result);
        }
        return list;
    }

    public static Model toModel(ResultSet resultSet) {
        RDFOutput rOut = new RDFOutput();
        return rOut.toModel(resultSet);
    }

    public static Model toModel(boolean booleanResult) {
        RDFOutput rOut = new RDFOutput();
        return rOut.toModel(booleanResult);
    }

    public static Resource asRDF(Model model, ResultSet resultSet) {
        RDFOutput rOut = new RDFOutput();
        return rOut.asRDF(model, resultSet);
    }

    public static Resource asRDF(Model model, boolean booleanResult) {
        RDFOutput rOut = new RDFOutput();
        return rOut.asRDF(model, booleanResult);
    }

    public static void output(ResultSet resultSet, ResultSetFormat rFmt) {
        ResultSetFormatter.output(System.out, resultSet, rFmt);
    }

    public static void output(OutputStream outStream, ResultSet resultSet, ResultSetFormat rFmt) {
        if (rFmt.equals(ResultSetFormat.syntaxXML)) {
            ResultSetFormatter.outputAsXML(outStream, resultSet);
            return;
        }
        if (rFmt.equals(ResultSetFormat.syntaxText)) {
            ResultSetFormatter.out(outStream, resultSet);
            return;
        }
        if (rFmt.equals(ResultSetFormat.syntaxJSON)) {
            ResultSetFormatter.outputAsJSON(outStream, resultSet);
            return;
        }
        if (rFmt.equals(ResultSetFormat.syntaxRDF_XML)) {
            ResultSetFormatter.outputAsRDF(outStream, "RDF/XML-ABBREV", resultSet);
            return;
        }
        ALog.warn(ResultSetFormatter.class, "Unknown ResultSetFormat: " + rFmt);
    }

    public static void outputAsRDF(String format, ResultSet resultSet) {
        ResultSetFormatter.outputAsRDF((OutputStream)System.out, format, resultSet);
    }

    public static void outputAsRDF(OutputStream outStream, String format, ResultSet resultSet) {
        PrintWriter out = FileUtils.asPrintWriterUTF8((OutputStream)outStream);
        ResultSetFormatter.outputAsRDF(out, format, resultSet);
        out.flush();
    }

    private static void outputAsRDF(PrintWriter out, String format, ResultSet resultSet) {
        Model m = ResultSetFormatter.toModel(resultSet);
        m.write((Writer)out, format);
        out.flush();
    }

    public static void outputAsRDF(String format, boolean booleanResult) {
        ResultSetFormatter.outputAsRDF((OutputStream)System.out, format, booleanResult);
    }

    public static void outputAsRDF(OutputStream outStream, String format, boolean booleanResult) {
        PrintWriter out = FileUtils.asPrintWriterUTF8((OutputStream)outStream);
        ResultSetFormatter.outputAsRDF(out, format, booleanResult);
        out.flush();
    }

    private static void outputAsRDF(PrintWriter out, String format, boolean booleanResult) {
        Model m = ResultSetFormatter.toModel(booleanResult);
        m.write((Writer)out, format);
        out.flush();
    }

    public static void outputAsXML(ResultSet qresults) {
        ResultSetFormatter.outputAsXML((OutputStream)System.out, qresults);
    }

    public static void outputAsXML(OutputStream outStream, ResultSet qresults) {
        ResultSetFormatter.outputAsXML(outStream, qresults, (String)null);
    }

    public static void outputAsXML(ResultSet qresults, String stylesheet) {
        ResultSetFormatter.outputAsXML((OutputStream)System.out, qresults, stylesheet);
    }

    public static void outputAsXML(OutputStream outStream, ResultSet qresults, String stylesheet) {
        XMLOutput xOut = new XMLOutput(stylesheet);
        xOut.format(outStream, qresults);
    }

    public static void outputAsXML(boolean booleanResult) {
        ResultSetFormatter.outputAsXML((OutputStream)System.out, booleanResult);
    }

    public static void outputAsXML(OutputStream outStream, boolean booleanResult) {
        ResultSetFormatter.outputAsXML(outStream, booleanResult, null);
    }

    public static void outputAsXML(boolean booleanResult, String stylesheet) {
        ResultSetFormatter.outputAsXML((OutputStream)System.out, booleanResult, stylesheet);
    }

    public static void outputAsXML(OutputStream outStream, boolean booleanResult, String stylesheet) {
        XMLOutputASK fmt = new XMLOutputASK(outStream, stylesheet);
        fmt.exec(booleanResult);
    }

    public static String asXMLString(ResultSet qresults) {
        return ResultSetFormatter.asXMLString(qresults, null);
    }

    public static String asXMLString(ResultSet qresults, String stylesheet) {
        XMLOutput xOut = new XMLOutput(stylesheet);
        return xOut.asString(qresults);
    }

    public static String asXMLString(boolean booleanResult) {
        return ResultSetFormatter.asXMLString(booleanResult, null);
    }

    public static String asXMLString(boolean booleanResult, String stylesheet) {
        XMLOutput xOut = new XMLOutput(stylesheet);
        return xOut.asString(booleanResult);
    }

    public static void outputAsJSON(ResultSet resultSet) {
        ResultSetFormatter.outputAsJSON((OutputStream)System.out, resultSet);
    }

    public static void outputAsJSON(OutputStream outStream, ResultSet resultSet) {
        JSONOutput jOut = new JSONOutput();
        jOut.format(outStream, resultSet);
    }

    public static void outputAsJSON(boolean booleanResult) {
        ResultSetFormatter.outputAsJSON((OutputStream)System.out, booleanResult);
    }

    public static void outputAsJSON(OutputStream outStream, boolean booleanResult) {
        JSONOutput jOut = new JSONOutput();
        jOut.format(outStream, booleanResult);
    }

    public static void outputAsSSE(boolean booleanResult) {
        ResultSetFormatter.outputAsSSE((OutputStream)System.out, booleanResult);
    }

    public static void outputAsSSE(OutputStream outStream, boolean booleanResult) {
        throw new ARQNotImplemented("outputAsSSE");
    }

    public static void outputAsSSE(ResultSet resultSet) {
        ResultSetFormatter.outputAsSSE((OutputStream)System.out, resultSet);
    }

    public static void outputAsSSE(ResultSet resultSet, Prologue prologue) {
        ResultSetFormatter.outputAsSSE(System.out, resultSet, prologue);
    }

    public static void outputAsSSE(OutputStream outStream, ResultSet resultSet) {
        ResultSetFormatter.outputAsSSE(outStream, resultSet, null);
    }

    public static void outputAsSSE(OutputStream outStream, ResultSet resultSet, Prologue prologue) {
        throw new ARQNotImplemented("outputAsSSE");
    }

    public static void outputAsCSV(boolean booleanResult) {
        ResultSetFormatter.outputAsCSV((OutputStream)System.out, booleanResult);
    }

    public static void outputAsCSV(OutputStream outStream, boolean booleanResult) {
        CSVOutput fmt = new CSVOutput();
        fmt.format(outStream, booleanResult);
    }

    public static void outputAsCSV(ResultSet resultSet) {
        ResultSetFormatter.outputAsCSV((OutputStream)System.out, resultSet);
    }

    public static void outputAsCSV(OutputStream outStream, ResultSet resultSet) {
        CSVOutput fmt = new CSVOutput();
        fmt.format(outStream, resultSet);
    }

    public static void outputAsTSV(boolean booleanResult) {
        ResultSetFormatter.outputAsTSV((OutputStream)System.out, booleanResult);
    }

    public static void outputAsTSV(OutputStream outStream, boolean booleanResult) {
        TSVOutput fmt = new TSVOutput();
        fmt.format(outStream, booleanResult);
    }

    public static void outputAsTSV(ResultSet resultSet) {
        ResultSetFormatter.outputAsTSV((OutputStream)System.out, resultSet);
    }

    public static void outputAsTSV(OutputStream outStream, ResultSet resultSet) {
        TSVOutput fmt = new TSVOutput();
        fmt.format(outStream, resultSet);
    }
}

