/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.OpModifier;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.E_Aggregator;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpGroupAgg
extends OpModifier {
    private VarExprList groupVars;
    private List<E_Aggregator> aggregators;

    public OpGroupAgg(Op subOp, VarExprList groupVars, List<E_Aggregator> aggregators) {
        super(subOp);
        this.groupVars = groupVars;
        this.aggregators = aggregators;
    }

    @Override
    public String getName() {
        return "group";
    }

    public VarExprList getGroupVars() {
        return this.groupVars;
    }

    public List<E_Aggregator> getAggregators() {
        return this.aggregators;
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op copy(Op subOp) {
        return new OpGroupAgg(subOp, this.groupVars, this.aggregators);
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public int hashCode() {
        int x = this.getSubOp().hashCode();
        if (this.groupVars != null) {
            x ^= this.groupVars.hashCode();
        }
        if (this.aggregators != null) {
            x ^= ((Object)this.aggregators).hashCode();
        }
        return x;
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpGroupAgg)) {
            return false;
        }
        OpGroupAgg opGroup = (OpGroupAgg)other;
        if (!Utils.equal(this.groupVars, opGroup.groupVars)) {
            return false;
        }
        if (!Utils.equal(this.aggregators, opGroup.aggregators)) {
            return false;
        }
        return this.getSubOp().equalTo(opGroup.getSubOp(), labelMap);
    }
}

