/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.opt;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_LogicalOr;
import com.hp.hpl.jena.sparql.expr.E_NotEquals;
import com.hp.hpl.jena.sparql.expr.E_NotOneOf;
import com.hp.hpl.jena.sparql.expr.E_OneOf;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;

public class TransformExpandOneOf
extends TransformCopy {
    public Op transform(OpFilter opFilter, Op subOp) {
        ExprList exprList = opFilter.getExprs();
        if (!this.interesting(exprList)) {
            return opFilter;
        }
        ExprList exprList2 = TransformExpandOneOf.expand(exprList);
        if (exprList2 == null) {
            return opFilter;
        }
        Op opFilter2 = OpFilter.filter(exprList2, subOp);
        return opFilter2;
    }

    private boolean interesting(ExprList exprList) {
        for (Expr e2 : exprList) {
            if (e2 instanceof E_OneOf) {
                return true;
            }
            if (!(e2 instanceof E_NotOneOf)) continue;
            return true;
        }
        return false;
    }

    private static ExprList expand(ExprList exprList) {
        ExprList exprList2 = new ExprList();
        for (Expr e2 : exprList) {
            Expr x;
            if (e2 instanceof E_OneOf) {
                E_OneOf exprOneOf = (E_OneOf)e2;
                x = exprOneOf.getLHS();
                ExprFunction2 disjunction = null;
                for (Expr sub : exprOneOf.getRHS()) {
                    E_Equals e22 = new E_Equals(x, sub);
                    if (disjunction == null) {
                        disjunction = e22;
                        continue;
                    }
                    disjunction = new E_LogicalOr(disjunction, e22);
                }
                if (disjunction == null) {
                    exprList2.add(NodeValue.FALSE);
                    continue;
                }
                exprList2.add(disjunction);
                continue;
            }
            if (e2 instanceof E_NotOneOf) {
                E_NotOneOf exprNotOneOf = (E_NotOneOf)e2;
                x = exprNotOneOf.getLHS();
                if (exprNotOneOf.getRHS().size() == 0) {
                    exprList2.add(NodeValue.TRUE);
                    continue;
                }
                for (Expr sub : exprNotOneOf.getRHS()) {
                    exprList2.add(new E_NotEquals(x, sub));
                }
                continue;
            }
            exprList2.add(e2);
        }
        return exprList2;
    }
}

