/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssemblerException;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssemblerVocab;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import java.util.List;

public class DataSourceAssembler
extends AssemblerBase
implements Assembler {
    public static Resource getType() {
        return DatasetAssemblerVocab.tDataset;
    }

    public Object open(Assembler a, Resource root, Mode mode) {
        DataSource ds = DatasetFactory.create();
        Resource dftGraph = GraphUtils.getResourceValue(root, DatasetAssemblerVocab.pDefaultGraph);
        if (dftGraph == null) {
            dftGraph = GraphUtils.getResourceValue(root, DatasetAssemblerVocab.pGraph);
        }
        Model dftModel = null;
        dftModel = dftGraph != null ? a.openModel(dftGraph) : GraphFactory.makePlainModel();
        ds.setDefaultModel(dftModel);
        List<RDFNode> nodes = GraphUtils.multiValue(root, DatasetAssemblerVocab.pNamedGraph);
        for (RDFNode n : nodes) {
            if (!(n instanceof Resource)) {
                throw new DatasetAssemblerException(root, "Not a resource: " + FmtUtils.stringForRDFNode(n));
            }
            Resource r = (Resource)n;
            String gName = GraphUtils.getAsStringValue(r, DatasetAssemblerVocab.pGraphName);
            Resource g = GraphUtils.getResourceValue(r, DatasetAssemblerVocab.pGraph);
            if (g == null) {
                g = GraphUtils.getResourceValue(r, DatasetAssemblerVocab.pGraphAlt);
                if (g != null) {
                    ALog.warn((Object)this, "Use of old vocabulary: use :graph not :graphData");
                } else {
                    throw new DatasetAssemblerException(root, "no graph for: " + gName);
                }
            }
            Model m = a.openModel(g);
            ds.addNamedModel(gName, m);
        }
        return ds;
    }
}

