/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFatalException;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.PrintSerializableBase;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.NoSuchElementException;

public abstract class QueryIteratorBase
extends PrintSerializableBase
implements QueryIterator {
    public static boolean traceIterators = false;
    private boolean finished = false;
    Throwable stackTrace = null;

    public QueryIteratorBase() {
        if (traceIterators) {
            this.stackTrace = new Throwable();
        }
    }

    protected abstract boolean hasNextBinding();

    protected abstract Binding moveToNextBinding();

    protected abstract void closeIterator();

    protected boolean isFinished() {
        return this.finished;
    }

    public final boolean hasNext() {
        try {
            if (this.finished) {
                return false;
            }
            boolean r = this.hasNextBinding();
            if (!r) {
                this.close();
            }
            return r;
        }
        catch (QueryFatalException ex) {
            ALog.fatal(this, "Fatal exception: " + ex.getMessage());
            this.abort();
            throw ex;
        }
    }

    public final Binding next() {
        return this.nextBinding();
    }

    public final Binding nextBinding() {
        try {
            if (this.finished) {
                throw new NoSuchElementException(Utils.className(this));
            }
            if (!this.hasNextBinding()) {
                throw new NoSuchElementException(Utils.className(this));
            }
            Binding obj = this.moveToNextBinding();
            if (obj == null) {
                throw new NoSuchElementException(Utils.className(this));
            }
            return obj;
        }
        catch (QueryFatalException ex) {
            ALog.fatal(this, "QueryFatalException", (Throwable)((Object)ex));
            this.abort();
            throw ex;
        }
    }

    public final void remove() {
        ALog.warn(this, "Call to QueryIterator.remove() : " + Utils.className(this) + ".remove");
        throw new UnsupportedOperationException(Utils.className(this) + ".remove");
    }

    public void close() {
        if (this.finished) {
            return;
        }
        try {
            this.closeIterator();
        }
        catch (QueryException ex) {
            ALog.warn(this, "QueryException in close()", (Throwable)((Object)ex));
        }
        this.finished = true;
    }

    public void abort() {
        if (this.finished) {
            return;
        }
        try {
            this.closeIterator();
        }
        catch (QueryException queryException) {
            // empty catch block
        }
        this.finished = true;
    }

    public String debug() {
        String s = "";
        if (this.stackTrace != null) {
            for (int i = 0; i < this.stackTrace.getStackTrace().length; ++i) {
                StackTraceElement e2 = this.stackTrace.getStackTrace()[i];
                if (e2.getMethodName().equals("<init>")) continue;
                s = s + e2.toString();
                break;
            }
        }
        return s;
    }
}

