/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.serializer.FmtExpr;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.FormatterTemplate;
import com.hp.hpl.jena.sparql.serializer.PrologueSerializer;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySerializer
implements QueryVisitor {
    static final int BLOCK_INDENT = 2;
    protected FormatterTemplate fmtTemplate;
    protected FormatterElement fmtElement;
    protected FmtExpr fmtExpr;
    protected IndentedWriter out = null;

    QuerySerializer(OutputStream _out, FormatterElement formatterElement, FmtExpr formatterExpr, FormatterTemplate formatterTemplate) {
        this(new IndentedWriter(_out), formatterElement, formatterExpr, formatterTemplate);
    }

    QuerySerializer(IndentedWriter iwriter, FormatterElement formatterElement, FmtExpr formatterExpr, FormatterTemplate formatterTemplate) {
        this.out = iwriter;
        this.fmtTemplate = formatterTemplate;
        this.fmtElement = formatterElement;
        this.fmtExpr = formatterExpr;
    }

    @Override
    public void startVisit(Query query2) {
    }

    @Override
    public void visitResultForm(Query query2) {
    }

    @Override
    public void visitPrologue(Prologue prologue) {
        int row1 = this.out.getRow();
        PrologueSerializer.output(this.out, prologue);
        int row2 = this.out.getRow();
        if (row1 != row2) {
            this.out.newline();
        }
    }

    @Override
    public void visitSelectResultForm(Query query2) {
        this.out.print("SELECT ");
        if (query2.isDistinct()) {
            this.out.print("DISTINCT ");
        }
        if (query2.isReduced()) {
            this.out.print("REDUCED ");
        }
        this.out.print(" ");
        if (query2.isQueryResultStar()) {
            this.out.print("*");
        } else {
            this.appendNamedExprList(query2, this.out, query2.getProject());
        }
        this.out.newline();
    }

    @Override
    public void visitConstructResultForm(Query query2) {
        this.out.print("CONSTRUCT ");
        if (query2.isQueryResultStar()) {
            this.out.print("*");
            this.out.newline();
        } else {
            this.out.incIndent(2);
            this.out.newline();
            Template t = query2.getConstructTemplate();
            t.visit(this.fmtTemplate);
            this.out.decIndent(2);
        }
    }

    @Override
    public void visitDescribeResultForm(Query query2) {
        this.out.print("DESCRIBE ");
        if (query2.isQueryResultStar()) {
            this.out.print("*");
        } else {
            this.appendVarList(query2, this.out, query2.getResultVars());
            if (query2.getResultVars().size() > 0 && query2.getResultURIs().size() > 0) {
                this.out.print(" ");
            }
            QuerySerializer.appendURIList(query2, this.out, query2.getResultURIs());
        }
        this.out.newline();
    }

    @Override
    public void visitAskResultForm(Query query2) {
        this.out.print("ASK");
        this.out.newline();
    }

    @Override
    public void visitDatasetDecl(Query query2) {
        if (query2.getGraphURIs() != null && query2.getGraphURIs().size() != 0) {
            for (String uri : query2.getGraphURIs()) {
                this.out.print("FROM ");
                this.out.print(FmtUtils.stringForURI(uri, query2));
                this.out.newline();
            }
        }
        if (query2.getNamedGraphURIs() != null && query2.getNamedGraphURIs().size() != 0) {
            for (String uri : query2.getNamedGraphURIs()) {
                this.out.print("FROM NAMED ");
                this.out.print(FmtUtils.stringForURI(uri, query2));
                this.out.newline();
            }
        }
    }

    @Override
    public void visitQueryPattern(Query query2) {
        if (query2.getQueryPattern() != null) {
            this.out.print("WHERE");
            this.out.incIndent(2);
            this.out.newline();
            Element el = query2.getQueryPattern();
            this.fmtElement.visitAsGroup(el);
            this.out.decIndent(2);
            this.out.newline();
        }
    }

    @Override
    public void visitGroupBy(Query query2) {
        if (query2.hasGroupBy()) {
            this.out.print("GROUP BY ");
            this.appendNamedExprList(query2, this.out, query2.getGroupBy());
            this.out.println();
        }
    }

    @Override
    public void visitHaving(Query query2) {
        if (query2.hasHaving()) {
            this.out.print("HAVING");
            for (Expr expr : query2.getHavingExprs()) {
                this.out.print(" ");
                this.fmtExpr.format(expr);
            }
            this.out.println();
        }
    }

    @Override
    public void visitOrderBy(Query query2) {
        if (query2.hasOrderBy()) {
            this.out.print("ORDER BY ");
            boolean first = true;
            for (SortCondition sc : query2.getOrderBy()) {
                if (!first) {
                    this.out.print(" ");
                }
                sc.format(this.fmtExpr, this.out);
                first = false;
            }
            this.out.println();
        }
    }

    @Override
    public void visitLimit(Query query2) {
        if (query2.hasLimit()) {
            this.out.print("LIMIT   " + query2.getLimit());
            this.out.newline();
        }
    }

    @Override
    public void visitOffset(Query query2) {
        if (query2.hasOffset()) {
            this.out.print("OFFSET  " + query2.getOffset());
            this.out.newline();
        }
    }

    @Override
    public void finishVisit(Query query2) {
        this.out.flush();
    }

    void appendVarList(Query query2, IndentedWriter sb, List<String> vars) {
        boolean first = true;
        for (String varName : vars) {
            Var var = Var.alloc(varName);
            if (!first) {
                sb.print(" ");
            }
            sb.print(var.toString());
            first = false;
        }
    }

    void appendNamedExprList(Query query2, IndentedWriter sb, VarExprList namedExprs) {
        boolean first = true;
        for (Var var : namedExprs.getVars()) {
            Expr expr = namedExprs.getExpr(var);
            if (!first) {
                sb.print(" ");
            }
            if (expr != null) {
                boolean needParens = true;
                if (expr.isFunction()) {
                    needParens = false;
                } else if (expr.isVariable()) {
                    needParens = false;
                }
                if (!Var.isAllocVar((Node)var)) {
                    needParens = true;
                }
                if (needParens) {
                    this.out.print("(");
                }
                this.fmtExpr.format(expr);
                if (!Var.isAllocVar((Node)var)) {
                    sb.print(" AS ");
                    sb.print(var.toString());
                }
                if (needParens) {
                    this.out.print(")");
                }
            } else {
                sb.print(var.toString());
            }
            first = false;
        }
    }

    static void appendURIList(Query query2, IndentedWriter sb, List<Node> vars) {
        SerializationContext cxt = new SerializationContext(query2);
        boolean first = true;
        for (Node node : vars) {
            if (!first) {
                sb.print(" ");
            }
            sb.print(FmtUtils.stringForNode(node, cxt));
            first = false;
        }
    }
}

