/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.update;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.modify.op.Update;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;

public class UpdateAction {
    public static void readExecute(String filename, Model model) {
        UpdateAction.readExecute(filename, model, null);
    }

    public static void readExecute(String filename, Dataset dataset) {
        UpdateAction.readExecute(filename, dataset, null);
    }

    public static void readExecute(String filename, Graph graph) {
        UpdateAction.readExecute(filename, GraphStoreFactory.create(graph), null);
    }

    public static void readExecute(String filename, GraphStore graphStore) {
        UpdateAction.readExecute(filename, graphStore, null);
    }

    public static void readExecute(String filename, Model model, QuerySolution initialBinding) {
        UpdateAction.readExecute(filename, GraphStoreFactory.create(model), BindingUtils.asBinding(initialBinding));
    }

    public static void readExecute(String filename, Dataset dataset, QuerySolution initialBinding) {
        UpdateAction.readExecute(filename, GraphStoreFactory.create(dataset), BindingUtils.asBinding(initialBinding));
    }

    public static void readExecute(String filename, Graph graph, Binding binding) {
        UpdateAction.readExecute(filename, GraphStoreFactory.create(graph), binding);
    }

    public static void readExecute(String filename, GraphStore graphStore, Binding binding) {
        UpdateRequest req = UpdateFactory.read(filename);
        UpdateAction.execute(req, graphStore, binding);
    }

    public static void parseExecute(String updateString, Model model) {
        UpdateAction.parseExecute(updateString, model, null);
    }

    public static void parseExecute(String updateString, Dataset dataset) {
        UpdateAction.parseExecute(updateString, dataset, null);
    }

    public static void parseExecute(String updateString, Graph graph) {
        UpdateAction.parseExecute(updateString, GraphStoreFactory.create(graph), null);
    }

    public static void parseExecute(String updateString, GraphStore graphStore) {
        UpdateAction.parseExecute(updateString, graphStore, null);
    }

    public static void parseExecute(String updateString, Model model, QuerySolution initialBinding) {
        if (initialBinding == null) {
            UpdateAction.parseExecute(updateString, GraphStoreFactory.create(model), null);
        } else {
            UpdateAction.parseExecute(updateString, GraphStoreFactory.create(model), BindingUtils.asBinding(initialBinding));
        }
    }

    public static void parseExecute(String updateString, Dataset dataset, QuerySolution initialBinding) {
        UpdateAction.parseExecute(updateString, GraphStoreFactory.create(dataset), BindingUtils.asBinding(initialBinding));
    }

    public static void parseExecute(String updateString, Graph graph, Binding binding) {
        UpdateAction.parseExecute(updateString, GraphStoreFactory.create(graph), binding);
    }

    public static void parseExecute(String updateString, GraphStore graphStore, Binding binding) {
        UpdateRequest req = UpdateFactory.create(updateString);
        UpdateAction.execute(req, graphStore, binding);
    }

    public static void execute(UpdateRequest request, Model model) {
        UpdateAction.execute(request, model, null);
    }

    public static void execute(UpdateRequest request, Dataset dataset) {
        UpdateAction.execute(request, dataset, null);
    }

    public static void execute(UpdateRequest request, Graph graph) {
        UpdateAction.execute(request, GraphStoreFactory.create(graph), null);
    }

    public static void execute(UpdateRequest request, GraphStore graphStore) {
        UpdateAction.execute(request, graphStore, null);
    }

    public static void execute(UpdateRequest request, Model model, QuerySolution initialBinding) {
        UpdateAction.execute(request, GraphStoreFactory.create(model), BindingUtils.asBinding(initialBinding));
    }

    public static void execute(UpdateRequest request, Dataset dataset, QuerySolution initialBinding) {
        UpdateAction.execute(request, GraphStoreFactory.create(dataset), BindingUtils.asBinding(initialBinding));
    }

    public static void execute(UpdateRequest request, Graph graph, Binding binding) {
        UpdateAction.execute(request, GraphStoreFactory.create(graph), binding);
    }

    public static void execute(UpdateRequest request, GraphStore graphStore, Binding binding) {
        UpdateProcessor uProc = UpdateFactory.create(request, graphStore, binding);
        uProc.execute();
    }

    public static void execute(Update update2, Model model) {
        UpdateAction.execute(update2, model, null);
    }

    public static void execute(Update update2, Dataset dataset) {
        UpdateAction.execute(update2, dataset, null);
    }

    public static void execute(Update update2, Graph graph) {
        UpdateAction.execute(update2, GraphStoreFactory.create(graph), null);
    }

    public static void execute(Update update2, GraphStore graphStore) {
        UpdateAction.execute(update2, graphStore, null);
    }

    public static void execute(Update update2, Model model, QuerySolution initialBinding) {
        UpdateAction.execute(update2, GraphStoreFactory.create(model), BindingUtils.asBinding(initialBinding));
    }

    public static void execute(Update update2, Dataset dataset, QuerySolution initialBinding) {
        UpdateAction.execute(update2, GraphStoreFactory.create(dataset), BindingUtils.asBinding(initialBinding));
    }

    public static void execute(Update update2, Graph graph, Binding binding) {
        UpdateAction.execute(update2, GraphStoreFactory.create(graph), binding);
    }

    public static void execute(Update update2, GraphStore graphStore, Binding binding) {
        UpdateProcessor uProc = UpdateFactory.create(update2, graphStore, binding);
        uProc.execute();
    }
}

