/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.beetl.core.ILoopStatus;
import org.beetl.core.IteratorLoopStatus;
import org.beetl.core.misc.PrimitiveArrayUtil;

public class GeneralLoopStatus
implements ILoopStatus {
    Iterator it;
    int size = -1;
    int index = 0;
    boolean hasData = false;

    public static ILoopStatus getIteratorStatus(Object o) {
        if (o instanceof Collection) {
            return new GeneralLoopStatus((Collection)o);
        }
        if (o instanceof Map) {
            return new GeneralLoopStatus((Map)o);
        }
        if (o instanceof Iterable) {
            return new IteratorLoopStatus(((Iterable)o).iterator());
        }
        if (o instanceof Iterator) {
            return new IteratorLoopStatus((Iterator)o);
        }
        if (o.getClass().isArray()) {
            return new GeneralLoopStatus(o, o.getClass().getComponentType().isPrimitive());
        }
        if (o instanceof Enumeration) {
            return new GeneralLoopStatus((Enumeration)o);
        }
        throw new RuntimeException("Object:" + o.getClass() + " \u4e0d\u80fd\u4f7f\u7528\u5728For\u5faa\u73af\u91cc");
    }

    public GeneralLoopStatus(Enumeration e) {
        ArrayList list = Collections.list(e);
        this.it = list.iterator();
        this.size = list.size();
    }

    public GeneralLoopStatus(Collection collection) {
        this.it = collection.iterator();
        this.size = collection.size();
    }

    public GeneralLoopStatus(Map map) {
        this.it = map.entrySet().iterator();
        this.size = map.size();
    }

    public GeneralLoopStatus(Object[] array) {
        this.it = new ArrayIterator(array);
        this.size = array.length;
    }

    public GeneralLoopStatus(Object o, boolean isPrimitive) {
        if (isPrimitive) {
            this.it = new PrimitiveIterator(o);
            this.size = ((PrimitiveIterator)this.it).length;
        } else {
            Object[] array = (Object[])o;
            this.it = new ArrayIterator(array);
            this.size = array.length;
        }
    }

    public GeneralLoopStatus(Iterable i) {
        this.it = i.iterator();
    }

    @Override
    public final boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public final Object next() {
        ++this.index;
        if (!this.hasData) {
            this.hasData = true;
        }
        return this.it.next();
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final int getDataIndex() {
        return this.index - 1;
    }

    @Override
    public final boolean isFirst() {
        return this.index == 1;
    }

    @Override
    public final boolean isLast() {
        return this.index == this.size;
    }

    @Override
    public final boolean isEven() {
        return this.index % 2 == 0;
    }

    @Override
    public final boolean isOdd() {
        return this.index % 2 == 1;
    }

    @Override
    public final boolean hasSize() {
        return this.size != -1;
    }

    @Override
    public int getSize() {
        if (this.size != -1) {
            return this.size;
        }
        throw new RuntimeException("\u96c6\u5408\u957f\u5ea6\u672a\u77e5,\u8bf7\u52ff\u4f7f\u7528size");
    }

    @Override
    public final boolean hasData() {
        return this.hasData;
    }

    static class PrimitiveIterator
    implements Iterator {
        Object o = null;
        int i = 0;
        int length = 0;

        PrimitiveIterator(Object o) {
            this.o = o;
            this.length = PrimitiveArrayUtil.getSize(o);
        }

        @Override
        public boolean hasNext() {
            return this.length > this.i;
        }

        public Object next() {
            return PrimitiveArrayUtil.getObject(this.o, this.i++);
        }

        @Override
        public void remove() {
        }
    }

    static class ArrayIterator
    implements Iterator {
        Object[] array = null;
        int i = 0;

        ArrayIterator(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.array.length > this.i;
        }

        public Object next() {
            return this.array[this.i++];
        }

        @Override
        public void remove() {
        }
    }
}

